/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractISFunctionReader
extends FunctionReader {
    protected AbstractISFunctionReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Function> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<Function> result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Function routine = AbstractISFunctionReader.this.createFunction(rs);
                result.add(routine);
            }
        });
        return result;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(AbstractISFunctionReader.class).getString("functions.sql");
        return node;
    }

    protected Function createFunction(ExResultSet rs) throws SQLException {
        Function routine = new Function(this.getString(rs, "ROUTINE_NAME"));
        routine.setCatalogName(this.getString(rs, "ROUTINE_CATALOG"));
        routine.setSchemaName(this.getString(rs, "ROUTINE_SCHEMA"));
        routine.setCreatedAt(rs.getTimestamp("CREATED"));
        routine.setLastAlteredAt(rs.getTimestamp("LAST_ALTERED"));
        routine.setDefinition(this.getString(rs, "ROUTINE_DEFINITION"));
        return routine;
    }
}

