/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.util.CommonUtils;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class DialectUtils {
    private static final ConcurrentMap<Class<?>, Dialect> CLASS_CACHE = new ConcurrentHashMap();

    private DialectUtils() {
    }

    public static <T extends Dialect> T getInstance(Class<T> clazz) {
        return DialectUtils.getInstance(clazz, null);
    }

    public static <T extends Dialect> T getInstance(Class<T> clazz, Supplier<Dialect> nextVersionDialectSupplier) {
        Dialect ret = (Dialect)CLASS_CACHE.get(clazz);
        if (ret != null) {
            return (T)ret;
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(Supplier.class);
            constructor.setAccessible(true);
            Dialect dialect = (Dialect)constructor.newInstance(nextVersionDialectSupplier);
            Dialect org = CLASS_CACHE.putIfAbsent(clazz, dialect);
            return (T)(org != null ? org : dialect);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long getDefaultTypeLength(String value) {
        if (value == null) {
            return 255L;
        }
        if (value.length() < 254) {
            return 254L;
        }
        if (value.length() < 1023) {
            return 1023L;
        }
        if (value.length() < 65535) {
            return 65535L;
        }
        return CommonUtils.LEN_1GB;
    }
}

