/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.util.CommonUtils;
import java.util.Date;
import java.util.Set;

public enum ClassDefaultTypes {
    TEXT(new Class[]{String.class}, DataType.VARCHAR, 1024L),
    LONGTEXT(new Class[]{String.class}, DataType.VARCHAR, CommonUtils.LEN_2GB),
    BOOLEAN(new Class[]{Boolean.TYPE, Boolean.class}, DataType.BOOLEAN),
    INTEGER(new Class[]{Integer.TYPE, Integer.class}, DataType.INT),
    BIGINT(new Class[]{Long.TYPE, Long.class}, DataType.BIGINT),
    Date(new Class[]{Date.class}, DataType.DATETIME);

    private final Set<Class<?>> clazzes;
    private final DataType types;
    private final Long maxlength;

    private ClassDefaultTypes(Class<?>[] clazzes, DataType types, Long maxlength) {
        this.clazzes = CommonUtils.set(clazzes);
        this.types = types;
        this.maxlength = maxlength;
    }

    private ClassDefaultTypes(Class<?>[] clazzes, DataType types) {
        this.clazzes = CommonUtils.set(clazzes);
        this.types = types;
        this.maxlength = null;
    }

    public Set<Class<?>> getClazzes() {
        return this.clazzes;
    }

    public DataType getTypes() {
        return this.types;
    }

    public Long getMaxlength() {
        return this.maxlength;
    }

    public static ClassDefaultTypes getTypes(Class<?> clazz, Long maxlength) {
        for (ClassDefaultTypes val : ClassDefaultTypes.values()) {
            if (!val.getClazzes().contains(clazz) || maxlength == null || val.getMaxlength() == null || val.getMaxlength().compareTo(maxlength) < 0) continue;
            return val;
        }
        for (ClassDefaultTypes val : ClassDefaultTypes.values()) {
            if (!val.getClazzes().contains(clazz)) continue;
            return val;
        }
        return TEXT;
    }

    public static ClassDefaultTypes getTypes(Class<?> clazz, long maxlength) {
        return ClassDefaultTypes.getTypes(clazz, (Long)maxlength);
    }

    public static ClassDefaultTypes getTypes(Class<?> clazz) {
        for (ClassDefaultTypes val : ClassDefaultTypes.values()) {
            if (!val.getClazzes().contains(clazz)) continue;
            return val;
        }
        return TEXT;
    }
}

