/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.UUIDConverter;
import com.sqlapp.data.db.datatype.AbstractNoSizeType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.util.BinaryUtils;
import com.sqlapp.util.CommonUtils;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class UUIDType
extends AbstractNoSizeType<UUIDType> {
    private static final long serialVersionUID = -8658816953027318522L;
    private UUIDConverter converter = new UUIDConverter();

    public UUIDType() {
        this(DataType.UUID.getTypeName());
    }

    protected UUIDType(String dataTypeName) {
        this.setDataType(DataType.UUID);
        this.initialize(dataTypeName);
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setUnsigned(true);
        this.setOctetSize(16L);
    }

    @Override
    public UUIDType setAsVarcharType() {
        this.setJdbcTypeHandler(new UuidVarcharTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setCreateFormat("VARCHAR(36)");
        this.setOctetSize(36L);
        this.setLiteral("'", "'");
        this.setDefaultValueLiteral("''");
        return this;
    }

    @Override
    public UUIDType setAsBinaryType() {
        this.setJdbcTypeHandler(new UuidBinaryTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setOctetSize(16L);
        return this;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof UUIDType;
    }

    private static class UuidBinaryTypeHandler
    extends DefaultJdbcTypeHandler {
        private static final long serialVersionUID = -3446371652551511555L;

        public UuidBinaryTypeHandler(JDBCType jdbcType, Converter<?> converter) {
            super(jdbcType, converter);
        }

        @Override
        public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
            if (x == null) {
                stmt.setNull(parameterIndex, -2);
                return;
            }
            UUID uuid = (UUID)CommonUtils.cast(this.statementConverter.convertObject(x));
            stmt.setObject(parameterIndex, (Object)BinaryUtils.toBinary(uuid), -2);
        }
    }

    private static class UuidVarcharTypeHandler
    extends DefaultJdbcTypeHandler {
        private static final long serialVersionUID = -3446371652551511555L;

        public UuidVarcharTypeHandler(JDBCType jdbcType, Converter<?> converter) {
            super(jdbcType, converter);
        }

        @Override
        public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
            if (x == null) {
                stmt.setNull(parameterIndex, 12);
                return;
            }
            UUID uuid = (UUID)CommonUtils.cast(this.statementConverter.convertObject(x));
            stmt.setString(parameterIndex, uuid.toString());
        }
    }
}

