/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.DefaultConverter;
import com.sqlapp.data.converter.StringConverter;
import com.sqlapp.data.db.datatype.AbstractLengthType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;

public class SqlXmlType
extends AbstractLengthType<SqlXmlType> {
    private static final long serialVersionUID = -8658816953027318522L;
    protected Converter<String> converter = new StringConverter();

    public SqlXmlType() {
        this(DataType.SQLXML.getTypeName());
    }

    protected SqlXmlType(String dataTypeName) {
        this.setDataType(DataType.SQLXML);
        this.initialize(dataTypeName);
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(this.getDataType().getJdbcType(), new DefaultConverter()));
        this.setUnsigned(true);
        this.setLiteralPrefix("'");
        this.setLiteralSuffix("'");
        this.setDefaultValueLiteral(this.withLiteral(""));
    }

    public SqlXmlType setAsVarchar() {
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(this.getDataType().getJdbcType(), this.converter));
        return this;
    }

    public SqlXmlType setAsNVarchar() {
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(DataType.NVARCHAR.getJdbcType(), this.converter));
        this.setDefaultValueLiteral("'0'");
        return this;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof SqlXmlType;
    }
}

