/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.StringConverter;
import com.sqlapp.data.db.datatype.AbstractLengthType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.util.CommonUtils;
import java.io.Reader;
import java.sql.Clob;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class NClobType
extends AbstractLengthType<NClobType> {
    private static final long serialVersionUID = -8658816953027318522L;
    protected StringConverter converter = new StringConverter();

    public NClobType() {
        this(DataType.NCLOB.getTypeName());
    }

    protected NClobType(String dataTypeName) {
        this.setDataType(DataType.NCLOB);
        this.setJdbcTypeHandler(new CLOBTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setDefaultLength(CommonUtils.LEN_1GB);
        this.initialize(dataTypeName);
        this.setLiteralPrefix("N'");
        this.setLiteralSuffix("'");
        this.setDefaultValueLiteral(this.withLiteral(""));
        this.setCharset("UTF-16");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof NClobType;
    }

    private static class CLOBTypeHandler
    extends DefaultJdbcTypeHandler {
        private static final long serialVersionUID = -3446371652551511555L;

        public CLOBTypeHandler(JDBCType jdbcType, Converter<?> converter) {
            super(jdbcType, converter);
        }

        @Override
        public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
            if (x == null) {
                stmt.setNull(parameterIndex, 2011);
                return;
            }
            if (x instanceof Clob) {
                stmt.setClob(parameterIndex, (Clob)x);
                return;
            }
            if (x instanceof Reader) {
                stmt.setClob(parameterIndex, (Reader)x);
                return;
            }
            String val = (String)CommonUtils.cast(this.statementConverter.convertObject(x));
            stmt.setObject(parameterIndex, (Object)val, 2011);
        }
    }
}

