/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DbDataTypeCollection;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.data.db.datatype.JdbcTypeHandler;
import com.sqlapp.data.db.datatype.LengthProperties;
import com.sqlapp.data.db.datatype.PrecisionProperties;
import com.sqlapp.data.db.datatype.ScaleProperties;
import com.sqlapp.data.schemas.CharacterSemantics;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.ArrayDimensionProperties;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import com.sqlapp.util.function.TriConsumer;
import java.io.Serializable;
import java.sql.JDBCType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DbDataType<T extends DbDataType<? super T>>
implements Serializable,
Cloneable {
    public static final String LENGTH_REPLACE = "{l}";
    public static final String PRECISION_REPLACE = "{p}";
    public static final String SCALE_REPLACE = "{s}";
    public static final String VALUESET_REPLACE = "{v}";
    private static final long serialVersionUID = -3972508957738381730L;
    protected List<Pattern> formatList = CommonUtils.list();
    protected List<Pattern> arrayFormatList = CommonUtils.list();
    protected Map<Long, DataType> sizeSarrogatedType = CommonUtils.map();
    private TriConsumer<DbDataType<?>, Matcher, DataTypeLengthProperties<?>> parseAndSetConsumer;
    private DbDataTypeCollection parent;
    private JDBCType jdbcType;
    private DataType dataType;
    private String dataTypeName;
    private String createFormat;
    private String createParameters;
    private Long octetSize;
    private Class<?> type;
    private boolean autoIncrementable;
    private boolean caseSensitive;
    private boolean fixedLength;
    private boolean fixedPrecision;
    private boolean fixedScale;
    private boolean nullable;
    private boolean searchable;
    private boolean searchableWithLike;
    private boolean unsigned;
    private boolean concurrencyType;
    private boolean literalSupported;
    private String literalPrefix;
    private String literalSuffix;
    private String defaultValueLiteral;
    private JdbcTypeHandler jdbcTypeHandler;
    private boolean supportsArray;
    private DbDataType<?> deprecatedSurrogateType;
    private DbDataType<?> surrogateType;
    private boolean dbSpecificType;
    private String charset;
    private Converter<?> converter;
    private Converter<?> sqlTextConverter;
    private boolean systemInternalType;
    private Set<CharacterSemantics> supportCharacterSemantics;
    private final Map<String, Matcher> arrayPatternCache;
    private final Set<String> arrayNoMatchPatternCache;
    private final Map<String, Matcher> patternCache;
    private final Set<String> noMatchPatternCache;

    public DbDataType() {
        this.parseAndSetConsumer = (own, m, column) -> {};
        this.parent = null;
        this.jdbcType = JDBCType.OTHER;
        this.dataType = null;
        this.dataTypeName = null;
        this.createFormat = null;
        this.createParameters = null;
        this.octetSize = null;
        this.type = null;
        this.autoIncrementable = false;
        this.caseSensitive = false;
        this.fixedLength = false;
        this.fixedPrecision = false;
        this.fixedScale = false;
        this.nullable = false;
        this.searchable = false;
        this.searchableWithLike = false;
        this.unsigned = false;
        this.concurrencyType = false;
        this.literalSupported = false;
        this.literalPrefix = null;
        this.literalSuffix = null;
        this.defaultValueLiteral = null;
        this.jdbcTypeHandler = null;
        this.supportsArray = true;
        this.deprecatedSurrogateType = null;
        this.surrogateType = null;
        this.dbSpecificType = false;
        this.charset = null;
        this.converter = null;
        this.sqlTextConverter = null;
        this.systemInternalType = false;
        this.supportCharacterSemantics = CommonUtils.set();
        this.arrayPatternCache = CommonUtils.map();
        this.arrayNoMatchPatternCache = CommonUtils.set();
        this.patternCache = CommonUtils.map();
        this.noMatchPatternCache = CommonUtils.set();
    }

    public DbDataType(String dataTypeName) {
        this.parseAndSetConsumer = (own, m, column) -> {};
        this.parent = null;
        this.jdbcType = JDBCType.OTHER;
        this.dataType = null;
        this.dataTypeName = null;
        this.createFormat = null;
        this.createParameters = null;
        this.octetSize = null;
        this.type = null;
        this.autoIncrementable = false;
        this.caseSensitive = false;
        this.fixedLength = false;
        this.fixedPrecision = false;
        this.fixedScale = false;
        this.nullable = false;
        this.searchable = false;
        this.searchableWithLike = false;
        this.unsigned = false;
        this.concurrencyType = false;
        this.literalSupported = false;
        this.literalPrefix = null;
        this.literalSuffix = null;
        this.defaultValueLiteral = null;
        this.jdbcTypeHandler = null;
        this.supportsArray = true;
        this.deprecatedSurrogateType = null;
        this.surrogateType = null;
        this.dbSpecificType = false;
        this.charset = null;
        this.converter = null;
        this.sqlTextConverter = null;
        this.systemInternalType = false;
        this.supportCharacterSemantics = CommonUtils.set();
        this.arrayPatternCache = CommonUtils.map();
        this.arrayNoMatchPatternCache = CommonUtils.set();
        this.patternCache = CommonUtils.map();
        this.noMatchPatternCache = CommonUtils.set();
        this.dataTypeName = dataTypeName;
    }

    protected void parseAndSet(Matcher matcher, DataTypeLengthProperties<?> column) {
        this.parseAndSetConsumer.accept(this, matcher, column);
    }

    public T setParseAndSet(TriConsumer<DbDataType<?>, Matcher, DataTypeLengthProperties<?>> parseAndSetConsumer) {
        this.parseAndSetConsumer = parseAndSetConsumer;
        return this.instance();
    }

    protected void initialize(String dataTypeName) {
        this.setTypeName(dataTypeName);
        this.setCreateFormat(dataTypeName);
    }

    public T setSizeSarrogation(Long size, DataType type) {
        this.sizeSarrogatedType.put(size, type);
        return this.instance();
    }

    public T setSizeSarrogation(long size, DataType type) {
        this.sizeSarrogatedType.put(size, type);
        return this.instance();
    }

    public DataType getSizeSarrogation(Long size) {
        return this.sizeSarrogatedType.get(size);
    }

    public DataType getSizeSarrogation(long size) {
        return this.sizeSarrogatedType.get(size);
    }

    public Converter<?> getConverter() {
        return this.converter;
    }

    public Set<CharacterSemantics> getSupportCharacterSemantics() {
        return this.supportCharacterSemantics;
    }

    public T setSupportCharacterSemantics(Set<CharacterSemantics> supportCharacterSemantics) {
        this.supportCharacterSemantics = supportCharacterSemantics;
        return this.instance();
    }

    public T setSupportCharacterSemantics(CharacterSemantics ... supportCharacterSemantics) {
        this.supportCharacterSemantics = supportCharacterSemantics != null ? CommonUtils.linkedSet(supportCharacterSemantics) : Collections.emptySet();
        return this.instance();
    }

    public T setConverter(Converter<?> converter) {
        this.converter = converter;
        return this.instance();
    }

    public Converter<?> getSqlTextConverter() {
        if (this.sqlTextConverter == null) {
            return this.getConverter();
        }
        return this.sqlTextConverter;
    }

    public T setSqlTextConverter(Converter<?> sqlTextConverter) {
        this.sqlTextConverter = sqlTextConverter;
        return this.instance();
    }

    public String getTypeName() {
        return this.dataTypeName;
    }

    protected T setTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
        if (this.createFormat == null) {
            this.createFormat = dataTypeName;
        }
        return this.instance();
    }

    public String getCreateFormat() {
        return this.createFormat;
    }

    public T setCreateFormat(String createFormat) {
        this.createFormat = createFormat;
        return this.instance();
    }

    public String getCreateParameters() {
        return this.createParameters;
    }

    public T setCreateParameters(String createParameters) {
        this.createParameters = createParameters;
        return this.instance();
    }

    public Class<?> getType() {
        return this.type;
    }

    public T setType(Class<?> clazz) {
        this.type = clazz;
        return this.instance();
    }

    public boolean isAutoIncrementable() {
        return this.autoIncrementable;
    }

    public T setAutoIncrementable(boolean autoIncrementable) {
        this.autoIncrementable = autoIncrementable;
        return this.instance();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public T setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this.instance();
    }

    public boolean isFixedLength() {
        return this.fixedLength;
    }

    public T setFixedLength(boolean fixedLength) {
        this.fixedLength = fixedLength;
        return this.instance();
    }

    public boolean isFixedPrecision() {
        return this.fixedPrecision;
    }

    public T setFixedPrecision(boolean fixedPrecision) {
        this.fixedPrecision = fixedPrecision;
        return this.instance();
    }

    public boolean isFixedScale() {
        return this.fixedScale;
    }

    public T setFixedScale(boolean fixedScale) {
        this.fixedScale = fixedScale;
        return this.instance();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public T setNullable(boolean nullable) {
        this.nullable = nullable;
        return this.instance();
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public T setSearchable(boolean searchable) {
        this.searchable = searchable;
        return this.instance();
    }

    public boolean isSearchableWithLike() {
        return this.searchableWithLike;
    }

    public T setSearchableWithLike(boolean searchableWithLike) {
        this.searchableWithLike = searchableWithLike;
        return this.instance();
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public T setUnsigned(boolean unsigned) {
        this.unsigned = unsigned;
        return this.instance();
    }

    public boolean isConcurrencyType() {
        return this.concurrencyType;
    }

    public T setConcurrencyType(boolean concurrencyType) {
        this.concurrencyType = concurrencyType;
        return this.instance();
    }

    public boolean isLiteralSupported() {
        return this.literalSupported;
    }

    public T setLiteralSupported(boolean literalSupported) {
        this.literalSupported = literalSupported;
        return this.instance();
    }

    public String getLiteralPrefix() {
        return this.literalPrefix;
    }

    public T setLiteralPrefix(String literalPrefix) {
        this.literalPrefix = literalPrefix;
        return this.instance();
    }

    public String withLiteral(String value) {
        if (value == null) {
            return null;
        }
        if (this.getDataType().isCharacter() || this.getDataType().isBinary() || this.getDataType().isDateTime()) {
            return this.getLiteralPrefix() + value.replace("'", "''") + this.getLiteralSuffix();
        }
        return value;
    }

    public String getLiteralSuffix() {
        return this.literalSuffix;
    }

    public T setLiteralSuffix(String literalSuffix) {
        this.literalSuffix = literalSuffix;
        return this.instance();
    }

    public String getDefaultValueLiteral() {
        return this.defaultValueLiteral;
    }

    public T setLiteral(String literalPrefix, String literalSuffix) {
        this.literalPrefix = literalPrefix;
        this.literalSuffix = literalSuffix;
        return this.instance();
    }

    public T setDefaultValueLiteral(String defaultValueLiteral) {
        this.defaultValueLiteral = defaultValueLiteral;
        return this.instance();
    }

    public int hashCode() {
        return this.getDataType().toString().hashCode() ^ this.getTypeName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbDataType)) {
            return false;
        }
        DbDataType objValue = (DbDataType)obj;
        if (!CommonUtils.eq(objValue.getCreateFormat(), this.getCreateFormat())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.getCreateParameters(), this.getCreateParameters())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.getType(), this.getType())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.getDefaultValueLiteral(), this.getDefaultValueLiteral())) {
            return false;
        }
        if (!CommonUtils.eq((Object)objValue.getDataType(), (Object)this.getDataType())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.getLiteralPrefix(), this.getLiteralPrefix())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.getLiteralSuffix(), this.getLiteralSuffix())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.getOctetSize(), this.getOctetSize())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.getTypeName(), this.getTypeName())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.getCharset(), this.getCharset())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isAutoIncrementable(), this.isAutoIncrementable())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isCaseSensitive(), this.isCaseSensitive())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isConcurrencyType(), this.isConcurrencyType())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isFixedLength(), this.isFixedLength())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isFixedPrecision(), this.isFixedPrecision())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isLiteralSupported(), this.isLiteralSupported())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isNullable(), this.isNullable())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isSearchable(), this.isSearchable())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isSearchableWithLike(), this.isSearchableWithLike())) {
            return false;
        }
        if (!CommonUtils.eq(objValue.isUnsigned(), this.isUnsigned())) {
            return false;
        }
        return CommonUtils.eq(objValue.isDeprecated(), this.isDeprecated());
    }

    public T clone() {
        try {
            return (T)((DbDataType)super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getColumCreateDefinition(Long sizeOrPrecision, Integer scale) {
        String result = this.getCreateFormat();
        if (sizeOrPrecision != null) {
            result = result.replace(LENGTH_REPLACE, sizeOrPrecision.toString());
            result = result.replace(PRECISION_REPLACE, sizeOrPrecision.toString());
        }
        if (scale != null) {
            result = result.replace(SCALE_REPLACE, scale.toString());
        }
        return result;
    }

    protected void setLiteralSupport() {
        if (this.getLiteralPrefix() == null && this.getLiteralSuffix() == null) {
            this.setLiteralSupported(false);
        }
        this.setLiteralSupported(true);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    protected T setDataType(DataType dataType) {
        this.dataType = dataType;
        this.jdbcType = dataType.getJdbcType();
        this.setTypeName(dataType.getTypeName());
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(this.getDataType()));
        this.setAutoIncrementable(dataType.isAutoIncrementable());
        if (dataType.getDefaultClass() != null) {
            this.setType(dataType.getDefaultClass());
        }
        if (this.getConverter() == null) {
            this.setConverter((Converter<?>)Converters.getDefault().getConverter(dataType.getDefaultClass()));
        }
        if (this instanceof LengthProperties) {
            this.setFixedLength(true);
        }
        if (this instanceof PrecisionProperties) {
            this.setFixedPrecision(true);
        }
        if (this instanceof ScaleProperties) {
            this.setFixedScale(true);
        }
        if (!dataType.isFixedSize()) {
            for (String alias : dataType.getAliasNames()) {
                this.addFormats(alias);
            }
        }
        return (T)this;
    }

    public JdbcTypeHandler getJdbcTypeHandler() {
        return this.jdbcTypeHandler;
    }

    public T setJdbcTypeHandler(JdbcTypeHandler jdbcTypeHandler) {
        this.jdbcTypeHandler = jdbcTypeHandler;
        return this.instance();
    }

    public T setJdbcTypeHandler(Converter<?> converter) {
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(this.getDataType().getJdbcType(), converter));
        return this.instance();
    }

    public T setJdbcTypeHandler(Converter<?> statementConverter, Converter<?> resultSetconverter) {
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(this.getDataType().getJdbcType(), statementConverter, resultSetconverter));
        return this.instance();
    }

    public Long getOctetSize() {
        return this.octetSize;
    }

    public T setOctetSize(Long octetSize) {
        this.octetSize = octetSize;
        return this.instance();
    }

    public T setOctetSize(int octetSize) {
        this.octetSize = octetSize;
        return this.instance();
    }

    protected static Long getLong(Matcher matcher, int count) {
        if (matcher.groupCount() < count) {
            return null;
        }
        String group = matcher.group(count);
        try {
            Long size = Long.valueOf(group);
            return size;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public T setAsVarcharType() {
        throw new UnsupportedOperationException(this.getClass().getName() + "#setAsVarcharType() does not support.");
    }

    public T setAsBinaryType() {
        throw new UnsupportedOperationException(this.getClass().getName() + "#setAsBinaryType() does not support.");
    }

    public boolean isDeprecated() {
        return this.deprecatedSurrogateType != null;
    }

    public DbDataType<?> getDeprecatedSurrogateType() {
        return this.deprecatedSurrogateType;
    }

    public DbDataType<?> setDeprecated(DbDataType<?> surrogateType) {
        if (this.getParent() == null) {
            throw new NullPointerException(this.getClass().getName() + "#getDbTypeCollection() is null.");
        }
        Map<DataType, DataType> map = this.getParent().getSurrogateMap();
        for (Map.Entry<DataType, DataType> entry : map.entrySet()) {
            DataType key = entry.getKey();
            DataType val = entry.getValue();
            if (!this.getDataType().equals((Object)val)) continue;
            map.put(key, this.getDataType().getSurrogate());
        }
        this.deprecatedSurrogateType = surrogateType;
        return this.instance();
    }

    public static String getCreateValueSetFormat(String start, String end) {
        return start + VALUESET_REPLACE + end;
    }

    public T addPrecisionScaleFormat(String dataTypeName) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#addPrecisionScaleFormat(String dataTypeName) does not support.");
    }

    public T addPrecisionFormat(String dataTypeName) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#addPrecisionFormat(String dataTypeName) does not support.");
    }

    public T addScaleFormat(String dataTypeName) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#addScaleFormat(String dataTypeName) does not support.");
    }

    public T addSizeFormat(String dataTypeName) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#addSizeFormat(String dataTypeName) does not support.");
    }

    protected DbDataTypeCollection getParent() {
        if (this.parent == null) {
            this.parent = new DbDataTypeCollection();
        }
        return this.parent;
    }

    protected T setParent(DbDataTypeCollection parent) {
        this.parent = parent;
        return this.instance();
    }

    protected T instance() {
        return (T)this;
    }

    public boolean isSupportsArray() {
        return this.supportsArray;
    }

    public T setSupportsArray(boolean supportsArray) {
        this.supportsArray = supportsArray;
        return this.instance();
    }

    public String getCharset() {
        return this.charset;
    }

    public T setCharset(String charset) {
        this.charset = charset;
        return this.instance();
    }

    public boolean isDbSpecificType() {
        return this.dbSpecificType;
    }

    public T setDbSpecificType(boolean dbSpecificType) {
        this.dbSpecificType = dbSpecificType;
        return this.instance();
    }

    public DbDataType<?> getSurrogateType() {
        return this.surrogateType;
    }

    public T setSurrogateType(DbDataType<?> surrogateType) {
        this.surrogateType = surrogateType;
        return this.instance();
    }

    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public T setJdbcType(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
        return this.instance();
    }

    public T addFormats(String ... formats) {
        for (String format : formats) {
            Pattern pattern = Pattern.compile(format.replace(" ", "\\s+"), 2);
            if (this.formatList.contains(pattern)) continue;
            this.formatList.add(pattern);
        }
        return this.instance();
    }

    public boolean isSystemInternalType() {
        return this.systemInternalType;
    }

    public T setSystemInternalType(boolean systemInternalType) {
        this.systemInternalType = systemInternalType;
        return this.instance();
    }

    private List<Pattern> getArrayFormatList() {
        if (!this.isSupportsArray()) {
            return this.arrayFormatList;
        }
        if (this.formatList.size() == this.arrayFormatList.size()) {
            return this.arrayFormatList;
        }
        for (Pattern pattern : this.formatList) {
            Pattern arrayPattern = Pattern.compile(this.getParent().getArrayPatternGenerator().apply(pattern.pattern()), 2);
            this.arrayFormatList.add(arrayPattern);
        }
        return this.arrayFormatList;
    }

    public T setFormats(String ... formats) {
        this.formatList.clear();
        return this.addFormats(formats);
    }

    protected Column parse(Matcher matcher) {
        Column column = new Column();
        this.parseAndSet(matcher, column);
        return column;
    }

    public boolean parseAndSet(String productDataType, DataTypeLengthProperties<?> column) {
        Matcher matcher = this.getArrayPatternMatcher(productDataType);
        if (matcher != null) {
            this.parseAndSet(matcher, column);
            column.setDataType(this.getDataType());
            String dataTypeName = column.getDataTypeName();
            if (!CommonUtils.eq(dataTypeName, this.getTypeName())) {
                SchemaUtils.setDataTypeNameInternal(this.getTypeName(), column);
            }
            if (column instanceof ArrayDimensionProperties) {
                this.getParent().getArrayDimensionHandler().accept(matcher, (ArrayDimensionProperties)((Object)column));
            }
            return true;
        }
        matcher = this.getPatternMatcher(productDataType);
        if (matcher != null) {
            this.parseAndSet(matcher, column);
            column.setDataType(this.getDataType());
            String dataTypeName = column.getDataTypeName();
            if (!CommonUtils.eq(dataTypeName, this.getTypeName())) {
                SchemaUtils.setDataTypeNameInternal(this.getTypeName(), column);
            }
            return true;
        }
        return false;
    }

    public boolean matchLength(DataTypeLengthProperties<?> column) {
        return column.getLength() == null;
    }

    private Matcher getArrayPatternMatcher(String productDataType) {
        Matcher matcher = this.arrayPatternCache.get(productDataType);
        if (matcher != null) {
            return matcher;
        }
        if (this.arrayNoMatchPatternCache.contains(productDataType)) {
            return null;
        }
        for (Pattern pattern : this.getArrayFormatList()) {
            matcher = pattern.matcher(productDataType);
            if (!matcher.matches()) continue;
            this.arrayPatternCache.put(productDataType, matcher);
            return matcher;
        }
        this.arrayNoMatchPatternCache.add(productDataType);
        return null;
    }

    private Matcher getPatternMatcher(String productDataType) {
        Matcher matcher = this.patternCache.get(productDataType);
        if (matcher != null) {
            return matcher;
        }
        if (this.noMatchPatternCache.contains(productDataType)) {
            return null;
        }
        for (Pattern pattern : this.formatList) {
            matcher = pattern.matcher(productDataType);
            if (!matcher.matches()) continue;
            this.patternCache.put(productDataType, matcher);
            return matcher;
        }
        this.noMatchPatternCache.add(productDataType);
        return null;
    }

    protected Integer getProperNumber(Integer maxNum, Integer defaultNum, Integer num) {
        Integer ret = defaultNum != null ? defaultNum : 0;
        if (num != null && maxNum != null) {
            ret = maxNum > num ? num.intValue() : maxNum.intValue();
        }
        return ret;
    }

    protected Integer getProperNumber(Integer maxNum, Integer defaultNum, Number num) {
        return this.getProperNumber(maxNum, defaultNum, Converters.getDefault().convertObject(num, Integer.class));
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder();
        builder.add("typeName", this.getTypeName());
        builder.add("dataType", (Object)this.getDataType());
        builder.add("surrogateType", this.getSurrogateType());
        builder.add("createFormat", this.getCreateFormat());
        builder.add("literalPrefix", this.getLiteralPrefix());
        builder.add("literalSuffix", this.getLiteralSuffix());
        this.buildToString(builder);
        return builder.toString();
    }

    protected void buildToString(ToStringBuilder builder) {
    }

    @FunctionalInterface
    public static interface DbDataTypeBiConsumer {
        public void accept(DbDataType<?> var1, Matcher var2, DataTypeLengthProperties<?> var3);
    }
}

