/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.db.datatype.MetaType;
import com.sqlapp.data.db.datatype.OleDbType;
import com.sqlapp.data.db.datatype.YesOrNo;
import com.sqlapp.data.db.dialect.util.GeometryUtils;
import com.sqlapp.data.geometry.Box;
import com.sqlapp.data.geometry.Circle;
import com.sqlapp.data.geometry.Line;
import com.sqlapp.data.geometry.Lseg;
import com.sqlapp.data.geometry.Path;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Polygon;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalDay;
import com.sqlapp.data.interval.IntervalDayToHour;
import com.sqlapp.data.interval.IntervalDayToMinute;
import com.sqlapp.data.interval.IntervalDayToSecond;
import com.sqlapp.data.interval.IntervalHour;
import com.sqlapp.data.interval.IntervalHourToMinute;
import com.sqlapp.data.interval.IntervalHourToSecond;
import com.sqlapp.data.interval.IntervalMinute;
import com.sqlapp.data.interval.IntervalMinuteToSecond;
import com.sqlapp.data.interval.IntervalMonth;
import com.sqlapp.data.interval.IntervalSecond;
import com.sqlapp.data.interval.IntervalYear;
import com.sqlapp.data.interval.IntervalYearToDay;
import com.sqlapp.data.interval.IntervalYearToMonth;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum DataType {
    ARRAY(JDBCType.ARRAY, MetaType.OTHER){}
    ,
    BIT(JDBCType.BIT, (Class)Boolean.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return BOOLEAN;
        }

        @Override
        public DataType getUpperSurrogate() {
            return TINYINT;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Boolean;
        }
    }
    ,
    TINYINT(JDBCType.TINYINT, (Class)Byte.class, MetaType.NUMERIC){

        @Override
        public DataType getUpperSurrogate() {
            return SMALLINT;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.TinyInt;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    SMALLINT(JDBCType.SMALLINT, (Class)Short.class, MetaType.NUMERIC){

        @Override
        public DataType getUpperSurrogate() {
            return MEDIUMINT;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.SmallInt;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    MEDIUMINT(JDBCType.INTEGER, (Class)Integer.class, MetaType.NUMERIC){

        @Override
        public DataType getUpperSurrogate() {
            return INT;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Integer;
        }
    }
    ,
    INT(JDBCType.INTEGER, (Class)Integer.class, MetaType.NUMERIC){

        @Override
        public DataType getUpperSurrogate() {
            return BIGINT;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Integer;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    BIGINT(JDBCType.BIGINT, (Class)Long.class, MetaType.NUMERIC){

        @Override
        public DataType getUpperSurrogate() {
            return DECIMAL;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.BigInt;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    HUGEINT(JDBCType.DECIMAL, (Class)BigInteger.class, MetaType.NUMERIC){

        @Override
        public DataType getUpperSurrogate() {
            return DECIMAL;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Decimal;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    SMALLSERIAL(JDBCType.SMALLINT, (Class)Short.class, MetaType.NUMERIC){

        @Override
        public boolean isAutoIncrementable() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return SMALLINT;
        }

        @Override
        public DataType getUpperSurrogate() {
            return SERIAL;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.SmallInt;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    SERIAL(JDBCType.INTEGER, (Class)Integer.class, MetaType.NUMERIC){

        @Override
        public boolean isAutoIncrementable() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return INT;
        }

        @Override
        public DataType getUpperSurrogate() {
            return BIGSERIAL;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Integer;
        }
    }
    ,
    BIGSERIAL(JDBCType.BIGINT, (Class)Long.class, MetaType.NUMERIC){

        @Override
        public boolean isAutoIncrementable() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return BIGINT;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.BigInt;
        }
    }
    ,
    UTINYINT(JDBCType.SMALLINT, "TINYINT UNSIGNED", (Class)Short.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return SMALLINT;
        }

        @Override
        public DataType getUpperSurrogate() {
            return USMALLINT;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.UnsignedTinyInt;
        }
    }
    ,
    USMALLINT(JDBCType.INTEGER, "SMALLINT UNSIGNED", (Class)Integer.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return MEDIUMINT;
        }

        @Override
        public DataType getUpperSurrogate() {
            return UMEDIUMINT;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.UnsignedSmallInt;
        }
    }
    ,
    UMEDIUMINT(JDBCType.INTEGER, "MEDIUMINT UNSIGNED", (Class)Integer.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return INT;
        }

        @Override
        public DataType getUpperSurrogate() {
            return UINT;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Integer;
        }
    }
    ,
    UINT(JDBCType.BIGINT, "INT UNSIGNED", (Class)Long.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return BIGINT;
        }

        @Override
        public DataType getUpperSurrogate() {
            return UBIGINT;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.UnsignedInt;
        }
    }
    ,
    UBIGINT(JDBCType.DECIMAL, "BIGINT UNSIGNED", (Class)BigInteger.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return DECIMAL;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.UnsignedBigInt;
        }
    }
    ,
    REAL(JDBCType.REAL, (Class)Float.class, MetaType.NUMERIC){

        @Override
        public DataType getUpperSurrogate() {
            return DOUBLE;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Single;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    DOUBLE(JDBCType.DOUBLE, (Class)Double.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return FLOAT;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Double;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    FLOAT(JDBCType.FLOAT, (Class)BigDecimal.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return DECIMALFLOAT;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Double;
        }
    }
    ,
    DECIMALFLOAT(JDBCType.DECIMAL, (Class)BigDecimal.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return DECIMAL;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Double;
        }
    }
    ,
    BOOLEAN(JDBCType.BOOLEAN, (Class)Boolean.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return BIT;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Boolean;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    DECIMAL(JDBCType.DECIMAL, (Class)BigDecimal.class, MetaType.NUMERIC){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isFixedScale() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return NUMERIC;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Decimal;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    NUMERIC(JDBCType.NUMERIC, (Class)BigDecimal.class, MetaType.NUMERIC){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isFixedScale() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return DECIMAL;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Decimal;
        }
    }
    ,
    SMALLMONEY(JDBCType.DECIMAL, (Class)BigDecimal.class, MetaType.NUMERIC){

        @Override
        public DataType getUpperSurrogate() {
            return MONEY;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Currency;
        }
    }
    ,
    MONEY(JDBCType.DECIMAL, (Class)BigDecimal.class, MetaType.NUMERIC){

        @Override
        public DataType getSurrogate() {
            return DECIMAL;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Currency;
        }
    }
    ,
    BINARY(JDBCType.BINARY, (Class)byte[].class, MetaType.BINARY){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return VARBINARY;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Binary;
        }
    }
    ,
    VARBINARY(JDBCType.VARBINARY, (Class)byte[].class, MetaType.BINARY){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getUpperSurrogate() {
            return LONGVARBINARY;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Binary;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    LONGVARBINARY(JDBCType.LONGVARBINARY, (Class)byte[].class, MetaType.BINARY){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return BLOB;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.LongVarBinary;
        }
    }
    ,
    BLOB(JDBCType.BLOB, (Class)byte[].class, MetaType.BINARY){

        @Override
        public DataType getSurrogate() {
            return LONGVARBINARY;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Binary;
        }
    }
    ,
    DATE(JDBCType.DATE, (Class)Date.class, MetaType.DATETIME){

        @Override
        public DataType getSurrogate() {
            return DATETIME;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.DBDate;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    SMALLDATETIME(JDBCType.TIMESTAMP, (Class)java.util.Date.class, MetaType.DATETIME){

        @Override
        public DataType getUpperSurrogate() {
            return DATETIME;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.DBDate;
        }
    }
    ,
    DATETIME(JDBCType.TIMESTAMP, (Class)java.util.Date.class, MetaType.DATETIME){

        @Override
        public DataType getUpperSurrogate() {
            return TIMESTAMP;
        }

        @Override
        public DataType getSurrogate() {
            return TIMESTAMP_WITH_TIMEZONE;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.DBTimeStamp;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    TIMESTAMP(JDBCType.TIMESTAMP, (Class)Timestamp.class, MetaType.DATETIME){

        @Override
        public boolean isFixedScale() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return DATETIME;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.DBTimeStamp;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    TIMESTAMP_WITH_TIMEZONE(JDBCType.TIMESTAMP_WITH_TIMEZONE, "TIMESTAMP WITH TIMEZONE", (Class)OffsetDateTime.class, MetaType.DATETIME){

        @Override
        public boolean isFixedScale() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return TIMESTAMP;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.DBTimeStamp;
        }
    }
    ,
    TIME(JDBCType.TIME, (Class)Time.class, MetaType.DATETIME){

        @Override
        public boolean isFixedScale() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return DATETIME;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.DBTime;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    TIME_WITH_TIMEZONE(JDBCType.TIME_WITH_TIMEZONE, "TIME WITH TIMEZONE", (Class)OffsetTime.class, MetaType.DATETIME){

        @Override
        public boolean isFixedScale() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return TIMESTAMP_WITH_TIMEZONE;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.DBTime;
        }
    }
    ,
    INTERVAL(JDBCType.OTHER, (Class)Interval.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return TIMESTAMP;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_YEAR(JDBCType.OTHER, "INTERVAL YEAR", (Class)IntervalYear.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_YEAR_TO_MONTH;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_MONTH(JDBCType.OTHER, "INTERVAL MONTH", (Class)IntervalMonth.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_YEAR_TO_MONTH;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_DAY(JDBCType.OTHER, "INTERVAL DAY", (Class)IntervalDay.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_HOUR(JDBCType.OTHER, "INTERVAL HOUR", (Class)IntervalHour.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_MINUTE(JDBCType.OTHER, "INTERVAL MINUTE", (Class)IntervalMinute.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_SECOND(JDBCType.OTHER, "INTERVAL SECOND", (Class)IntervalSecond.class, MetaType.INTERVAL){

        @Override
        public boolean isFixedScale() {
            return false;
        }

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_YEAR_TO_MONTH(JDBCType.OTHER, "INTERVAL YEAR TO MONTH", (Class)IntervalYearToMonth.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_YEAR_TO_DAY(JDBCType.OTHER, "INTERVAL YEAR TO DAY", (Class)IntervalYearToDay.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_DAY_TO_HOUR(JDBCType.OTHER, "INTERVAL DAY TO HOUR", (Class)IntervalDayToHour.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_DAY_TO_MINUTE(JDBCType.OTHER, "INTERVAL DAY TO MINUTE", (Class)IntervalDayToMinute.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_DAY_TO_SECOND(JDBCType.OTHER, "INTERVAL DAY TO SECOND", (Class)IntervalDayToSecond.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_MINUTE_TO_SECOND(JDBCType.OTHER, "INTERVAL MINUTE TO SECOND", (Class)IntervalMinuteToSecond.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_HOUR_TO_MINUTE(JDBCType.OTHER, "INTERVAL HOUR TO MINUTE", (Class)IntervalHourToMinute.class, MetaType.INTERVAL){

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    INTERVAL_HOUR_TO_SECOND(JDBCType.OTHER, "INTERVAL HOUR TO SECOND", (Class)IntervalHourToSecond.class, MetaType.INTERVAL){

        @Override
        public boolean isFixedScale() {
            return false;
        }

        @Override
        public DataType getSurrogate() {
            return INTERVAL_DAY_TO_SECOND;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    CHAR(JDBCType.CHAR, (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public DataType getNationalSurrogate() {
            return NCHAR;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Char;
        }
    }
    ,
    VARCHAR(JDBCType.VARCHAR, (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getUpperSurrogate() {
            return LONGVARCHAR;
        }

        @Override
        public DataType getNationalSurrogate() {
            return NVARCHAR;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    LONGVARCHAR(JDBCType.LONGVARCHAR, (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return LONGNVARCHAR;
        }

        @Override
        public DataType getUpperSurrogate() {
            return CLOB;
        }

        @Override
        public DataType getNationalSurrogate() {
            return LONGNVARCHAR;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.LongVarChar;
        }
    }
    ,
    CLOB(JDBCType.CLOB, (Class)String.class, MetaType.CHARACTER){

        @Override
        public DataType getUpperSurrogate() {
            return VARCHAR;
        }

        @Override
        public DataType getNationalSurrogate() {
            return NCLOB;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.LongVarChar;
        }
    }
    ,
    NVARCHAR(JDBCType.NVARCHAR, (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getUpperSurrogate() {
            return LONGNVARCHAR;
        }

        @Override
        public DataType getNationalSurrogate() {
            return VARCHAR;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarWChar;
        }
    }
    ,
    LONGNVARCHAR(JDBCType.LONGNVARCHAR, "LONGNVARCHAR", (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getUpperSurrogate() {
            return NCLOB;
        }

        @Override
        public boolean isNationalCharacter() {
            return true;
        }

        @Override
        public DataType getNationalSurrogate() {
            return LONGVARCHAR;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarWChar;
        }
    }
    ,
    NCLOB(JDBCType.NCLOB, (Class)String.class, MetaType.CHARACTER){

        @Override
        public DataType getSurrogate() {
            return NVARCHAR;
        }

        @Override
        public boolean isNationalCharacter() {
            return true;
        }

        @Override
        public DataType getNationalSurrogate() {
            return CLOB;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarWChar;
        }
    }
    ,
    NCHAR(JDBCType.NCHAR, (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return NVARCHAR;
        }

        @Override
        public boolean isNationalCharacter() {
            return true;
        }

        @Override
        public DataType getNationalSurrogate() {
            return CHAR;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarWChar;
        }
    }
    ,
    SEARCHABLE_SHORTTEXT(JDBCType.VARCHAR, "SHORTTEXT", (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public DataType getUpperSurrogate() {
            return SEARCHABLE_TEXT;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    SEARCHABLE_TEXT(JDBCType.VARCHAR, "TEXT", (Class)String.class, MetaType.CHARACTER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    ALPHANUM(JDBCType.VARCHAR, (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    VARCHAR_IGNORECASE(JDBCType.VARCHAR, "VARCHAR_IGNORECASE", (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    MCHAR(JDBCType.VARCHAR, (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return MVARCHAR;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    MVARCHAR(JDBCType.VARCHAR, (Class)String.class, MetaType.CHARACTER){

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    INET(JDBCType.OTHER, (Class)String.class, MetaType.CHARACTER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 45L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    CIDR(JDBCType.OTHER, "CIDR", (Class)String.class, MetaType.CHARACTER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 49L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    MACADDR(JDBCType.OTHER, "MACADDR", (Class)String.class, MetaType.CHARACTER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 17L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    UUID(JDBCType.OTHER, "UUID", (Class)UUID.class, MetaType.BINARY){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 36L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Guid;
        }

        @Override
        public boolean isDefaultClassType() {
            return true;
        }
    }
    ,
    GEOGRAPHY(JDBCType.OTHER, "GEOGRAPHY", (Class)GeometryUtils.getGeographyClass(), MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return GEOMETRY;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    GEOMETRY(JDBCType.OTHER, "GEOMETRY", (Class)GeometryUtils.getGeometryClass(), MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    POINT(JDBCType.OTHER, "POINT", (Class)Point.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 255L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    CIRCLE(JDBCType.OTHER, "CIRCLE", (Class)Circle.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 255L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    LINE(JDBCType.OTHER, "CIRCLE", (Class)Line.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 255L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    BOX(JDBCType.OTHER, "BOX", (Class)Box.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 255L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    LSEG(JDBCType.OTHER, "LSEG", (Class)Lseg.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 255L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    PATH(JDBCType.OTHER, "PATH", (Class)Path.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 255L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    POLYGON(JDBCType.OTHER, "POLYGON", (Class)Polygon.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return CLOB;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    SQLXML(JDBCType.SQLXML, "SQLXML", (Class)SQLXML.class, MetaType.CHARACTER){

        @Override
        public DataType getSurrogate() {
            return CLOB;
        }

        @Override
        public boolean isJdbcBaseType() {
            return true;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    JSON(JDBCType.VARCHAR, "JSON", (Class)String.class, MetaType.CHARACTER){

        @Override
        public DataType getSurrogate() {
            return NCLOB;
        }

        @Override
        public DataType getUpperSurrogate() {
            return JSONB;
        }

        @Override
        public boolean isNationalCharacter() {
            return true;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    JSONB(JDBCType.VARCHAR, "JSONB", (Class)String.class, MetaType.CHARACTER){

        @Override
        public DataType getSurrogate() {
            return JSON;
        }

        @Override
        public boolean isNationalCharacter() {
            return true;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    ROWID(JDBCType.ROWID, "ROWID", (Class)String.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }
    }
    ,
    DATALINK(JDBCType.DATALINK, "DATALINK", MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }
    }
    ,
    DOMAIN(JDBCType.DISTINCT, "DOMAIN", MetaType.OTHER){

        @Override
        public boolean isDomain() {
            return true;
        }
    }
    ,
    OTHER(JDBCType.OTHER, "OTHER", MetaType.OTHER){

        @Override
        public boolean isOther() {
            return true;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.IUnknown;
        }
    }
    ,
    REF(JDBCType.REF, "REF", MetaType.OTHER){}
    ,
    STRUCT(JDBCType.STRUCT, "STRUCT", MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return CLOB;
        }

        @Override
        public boolean isType() {
            return true;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.IUnknown;
        }
    }
    ,
    JAVA_OBJECT(JDBCType.JAVA_OBJECT, "JAVA_OBJECT", (Class)Serializable.class, MetaType.OTHER){

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.IUnknown;
        }
    }
    ,
    NULL(JDBCType.NULL, "NULL", null, MetaType.OTHER){}
    ,
    ANY_DATA(JDBCType.OTHER, "ANYDATA", (Class)Object.class, MetaType.OTHER){

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.IUnknown;
        }
    }
    ,
    ROWVERSION(JDBCType.BINARY, "ROWVERSION", (Class)byte[].class, MetaType.BINARY){

        @Override
        public DataType getSurrogate() {
            return BINARY;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 8L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    TIMESTAMPVERSION(JDBCType.TIMESTAMP, "TIMESTAMPVERSION", (Class)Timestamp.class, MetaType.DATETIME){

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    ENUM(JDBCType.VARCHAR, "ENUM", (Class)String.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return CLOB;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    SET(JDBCType.VARCHAR, "SET", (Class)String.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return CLOB;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.VarChar;
        }
    }
    ,
    YES_OR_NO(JDBCType.VARCHAR, "YES_OR_NO", (Class)YesOrNo.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 3L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }

        @Override
        public OleDbType getOleDbType() {
            return OleDbType.Boolean;
        }
    }
    ,
    SQL_IDENTIFIER(JDBCType.VARCHAR, "SQL_IDENTIFIER", (Class)String.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 255L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    CHARACTER_DATA(JDBCType.VARCHAR, "CHARACTER_DATA", (Class)String.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return VARCHAR;
        }

        @Override
        public Long getSurrogateTypeLength() {
            return 255L;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    }
    ,
    CARDINAL_NUMBER(JDBCType.INTEGER, "CARDINAL_NUMBER", (Class)Integer.class, MetaType.OTHER){

        @Override
        public DataType getSurrogate() {
            return INT;
        }

        @Override
        public boolean isJdbcBaseType() {
            return false;
        }
    };

    private final JDBCType jdbcType;
    private final String typeName;
    private final Class<?> defaultClass;
    private final MetaType metaType;
    private static final Map<JDBCType, DataType> jdbcMap;
    private static final Map<DataType, DataType> surrogateTypeMap;
    private static final Map<DataType, DataType> upperSurrogateTypeMap;
    private static final Map<String, DataType> nameTypeMap;
    private static final Map<DataType, Set<String>> typeAliasNameMap;
    private static final Map<Pattern, DataType> patternTypeMap;
    private static final Map<Class<?>, DataType> classTypeMap;
    private static final Map<Integer, JDBCType> TYPE_NUMBER_MAP;

    public boolean isAutoIncrementable() {
        return false;
    }

    static void initializeJdbcMap() {
        for (DataType type : DataType.values()) {
            DataType.addJdbcMap(type);
        }
    }

    private static void addJdbcMap(DataType type) {
        if (type.isJdbcBaseType()) {
            if (jdbcMap.containsKey(type.jdbcType)) {
                throw new RuntimeException("Duplicate jdbcType=" + type);
            }
            jdbcMap.put(type.jdbcType, type);
        }
    }

    static void initializeClassTypeMap() {
        for (DataType type : DataType.values()) {
            if (!type.isDefaultClassType()) continue;
            Class<?> pclazz = CommonUtils.getPrimitiveClass(type.getDefaultClass());
            Class<?> wclazz = CommonUtils.getWrapperClass(type.getDefaultClass());
            if (pclazz != null) {
                classTypeMap.put(pclazz, type);
            }
            if (wclazz != null) {
                classTypeMap.put(wclazz, type);
            }
            classTypeMap.put(type.getDefaultClass(), type);
        }
        classTypeMap.put(Instant.class, DATETIME);
        classTypeMap.put(LocalDate.class, DATE);
        classTypeMap.put(LocalTime.class, TIME);
        classTypeMap.put(LocalDateTime.class, DATETIME);
    }

    protected boolean isJdbcBaseType() {
        return true;
    }

    static void initializeNameTypeMap() {
        for (DataType type : DataType.values()) {
            String name = type.toString();
            DataType.setAlias(type, name);
            if (name.contains("_")) {
                DataType.setAlias(type, name.replace('_', ' '));
            }
            if (CommonUtils.eq(name, type.getTypeName())) continue;
            DataType.setAlias(type, type.getTypeName());
        }
        DataType.setAlias(UTINYINT, "INT8 UNSIGNED");
        DataType.setAlias(USMALLINT, "INT16 UNSIGNED");
        DataType.setAlias(UMEDIUMINT, "INT24 UNSIGNED");
        DataType.setAlias(UINT, "INT32 UNSIGNED");
        DataType.setAlias(UINT, "INTEGER UNSIGNED");
        DataType.setAlias(UBIGINT, "INT64 UNSIGNED");
        DataType.setAlias(UBIGINT, "INT64 UNSIGNED");
        DataType.setAlias(DECIMAL, "DEC");
        DataType.setAlias(CHAR, "CHARACTER");
        DataType.setAlias(NCHAR, "NATIONAL CHARACTER");
        DataType.setAlias(VARCHAR, "CHARACTER VARYING");
        DataType.setAlias(NVARCHAR, "NATIONAL CHARACTER VARYING");
        DataType.setAlias(CLOB, "CHARACTER LARGE OBJECT");
        DataType.setAlias(NCLOB, "NATIONAL CHARACTER LARGE OBJECT");
        DataType.setAlias(DOUBLE, "DOUBLE PRECISION");
        DataType.setAlias(TIMESTAMP, "TIMESTAMP WITHOUT TIME ZONE");
        DataType.setAlias(TIME, "TIME WITHOUT TIME ZONE");
        DataType.setAlias(BLOB, "BINARY LARGE OBJECT");
    }

    static void setAlias(DataType type, String alias) {
        nameTypeMap.put(alias, type);
        if (!typeAliasNameMap.containsKey((Object)type)) {
            typeAliasNameMap.put(type, CommonUtils.upperSet());
        }
        Set<String> set = typeAliasNameMap.get((Object)type);
        if (!CommonUtils.eq(type.getTypeName(), alias)) {
            set.add(alias);
        }
    }

    static void initializeSurrogateMap() {
        for (DataType type : DataType.values()) {
            if (type.getSurrogate() != null) {
                surrogateTypeMap.put(type, type.getSurrogate());
            }
            if (type.getUpperSurrogate() == null) continue;
            upperSurrogateTypeMap.put(type, type.getUpperSurrogate());
        }
    }

    private DataType(JDBCType jdbcType, String typeName, MetaType metaType) {
        this(jdbcType, typeName, null, metaType);
    }

    private DataType(JDBCType jdbcType, MetaType metaType) {
        this(jdbcType, null, null, metaType);
    }

    private DataType(JDBCType jdbcType, Class<?> defaultClass, MetaType metaType) {
        this(jdbcType, null, defaultClass, metaType);
    }

    private DataType(JDBCType jdbcType, String typeName, Class<?> defaultClass, MetaType metaType) {
        this.jdbcType = jdbcType;
        this.typeName = typeName;
        this.defaultClass = defaultClass;
        this.metaType = metaType;
    }

    public static DataType toType(String key) {
        if (nameTypeMap.containsKey(key)) {
            return nameTypeMap.get(key);
        }
        for (Map.Entry<Pattern, DataType> entry : patternTypeMap.entrySet()) {
            Pattern pattern = entry.getKey();
            Matcher matcher = pattern.matcher(key);
            if (!matcher.matches()) continue;
            return entry.getValue();
        }
        return OTHER;
    }

    public static DataType valueOf(int val) {
        DataType dataType = jdbcMap.get(DataType.getJDBCType(val));
        if (dataType != null) {
            return dataType;
        }
        return OTHER;
    }

    public static DataType valueOf(Class<?> clazz) {
        DataType dataType = classTypeMap.get(clazz);
        if (dataType != null) {
            return dataType;
        }
        return VARCHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JDBCType getJDBCType(int val) {
        if (TYPE_NUMBER_MAP.isEmpty()) {
            Map<Integer, JDBCType> map = TYPE_NUMBER_MAP;
            synchronized (map) {
                if (TYPE_NUMBER_MAP.isEmpty()) {
                    for (JDBCType jdbcType : JDBCType.values()) {
                        TYPE_NUMBER_MAP.put(jdbcType.getVendorTypeNumber(), jdbcType);
                    }
                }
            }
        }
        return TYPE_NUMBER_MAP.get(val);
    }

    public Set<String> getAliasNames() {
        return typeAliasNameMap.get((Object)this);
    }

    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public Class<?> getDefaultClass() {
        return this.defaultClass;
    }

    public MetaType getMetaTtype() {
        return this.metaType;
    }

    public OleDbType getOleDbType() {
        return null;
    }

    public boolean isNumeric() {
        return this.metaType.isNumeric();
    }

    public boolean isInterval() {
        return this.metaType.isInterval();
    }

    public boolean isBinary() {
        return this.metaType.isBinary();
    }

    public boolean isDefaultClassType() {
        return false;
    }

    public boolean isCharacter() {
        return this.metaType.isCharacter();
    }

    public boolean isBoolean() {
        return this == BOOLEAN || this == BIT;
    }

    public boolean isDateTime() {
        return this.metaType.isDateTime();
    }

    public boolean isNationalCharacter() {
        return false;
    }

    public boolean isDomain() {
        return false;
    }

    public boolean isType() {
        return false;
    }

    public boolean isOther() {
        return false;
    }

    public boolean isFixedSize() {
        return false;
    }

    public boolean isFixedScale() {
        return false;
    }

    public String getTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        return this.toString();
    }

    public DataType getSurrogate() {
        return null;
    }

    public DataType getNationalSurrogate() {
        return null;
    }

    public Long getSurrogateTypeLength() {
        return null;
    }

    public DataType getUpperSurrogate() {
        return null;
    }

    public static Map<DataType, DataType> getSurrogateMap() {
        return CommonUtils.cloneMap(surrogateTypeMap);
    }

    public static Map<DataType, DataType> getUpperSurrogateMap() {
        return CommonUtils.cloneMap(upperSurrogateTypeMap);
    }

    static {
        jdbcMap = CommonUtils.map();
        surrogateTypeMap = CommonUtils.enumMap(DataType.class);
        upperSurrogateTypeMap = CommonUtils.enumMap(DataType.class);
        nameTypeMap = CommonUtils.upperMap();
        typeAliasNameMap = CommonUtils.enumMap(DataType.class);
        patternTypeMap = CommonUtils.map();
        classTypeMap = CommonUtils.map();
        DataType.initializeJdbcMap();
        DataType.initializeSurrogateMap();
        DataType.initializeNameTypeMap();
        DataType.initializeClassTypeMap();
        for (Map.Entry<String, DataType> entry : nameTypeMap.entrySet()) {
            if (entry.getKey().contains("_")) continue;
            String name = "\\s*" + entry.getKey() + "\\s*";
            Pattern pattern = Pattern.compile(name.replace(" ", "\\s+"), 2);
            patternTypeMap.put(pattern, entry.getValue());
        }
        TYPE_NUMBER_MAP = CommonUtils.concurrentMap();
    }
}

