/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.BooleanConverter;
import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.db.datatype.AbstractNoSizeType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.util.CommonUtils;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BitType
extends AbstractNoSizeType<BitType> {
    private static final long serialVersionUID = -8658816953027318522L;
    protected Converter<Boolean> converter = new BooleanConverter();

    public BitType() {
        this(DataType.BIT.getTypeName());
    }

    public BitType(String dataTypeName) {
        this.setDataType(DataType.BIT);
        this.initialize(dataTypeName);
        this.setUnsigned(true);
    }

    public BitType setAsStringType() {
        this.setJdbcTypeHandler(new BitStringTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setDefaultValueLiteral("'0'");
        return this;
    }

    public BitType setAsNumericType() {
        this.setJdbcTypeHandler(new BitNumericTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setDefaultValueLiteral("0");
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof BitType;
    }

    static class BitNumericTypeHandler
    extends DefaultJdbcTypeHandler {
        private static final long serialVersionUID = -3446371652551511555L;

        public BitNumericTypeHandler(JDBCType jdbcType, Converter<Boolean> converter) {
            super(jdbcType, converter);
        }

        @Override
        public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
            if (x == null) {
                stmt.setNull(parameterIndex, -6);
                return;
            }
            Boolean bool = (Boolean)CommonUtils.cast(this.statementConverter.convertObject(x));
            if (bool.booleanValue()) {
                byte s = 1;
                stmt.setByte(parameterIndex, s);
            } else {
                byte s = 0;
                stmt.setByte(parameterIndex, s);
            }
        }
    }

    static class BitStringTypeHandler
    extends DefaultJdbcTypeHandler {
        private static final long serialVersionUID = -3446371652551511555L;

        public BitStringTypeHandler(JDBCType jdbcType, Converter<Boolean> converter) {
            super(jdbcType, converter);
        }

        @Override
        public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
            if (x == null) {
                stmt.setNull(parameterIndex, 12);
                return;
            }
            Boolean bool = (Boolean)CommonUtils.cast(this.statementConverter.convertObject(x));
            if (bool.booleanValue()) {
                stmt.setString(parameterIndex, "1");
            } else {
                stmt.setString(parameterIndex, "0");
            }
        }
    }
}

