/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.PrecisionProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StringUtils;
import java.util.regex.Matcher;

public abstract class AbstractPrecisionType<T extends DbDataType<T>>
extends DbDataType<T>
implements PrecisionProperties<T> {
    private static final long serialVersionUID = 8982873757752848020L;
    private Integer defaultPrecision = null;
    private Integer maxPrecision = null;

    @Override
    protected void initialize(String typeName) {
        this.setFixedPrecision(true);
        this.setTypeName(typeName);
        this.setCreateFormat(typeName + "(", ")");
        this.addFormats(typeName);
        this.addPrecisionFormat(typeName);
    }

    public T setCreateFormat(String start, String end) {
        this.setCreateFormat(start + "{p}" + end);
        return this.instance();
    }

    @Override
    public boolean matchLength(DataTypeLengthProperties<?> column) {
        return column.getLength() != null && this.getMaxPrecision() != null && this.getMaxPrecision().longValue() - column.getLength() >= 0L;
    }

    @Override
    public Integer getDefaultPrecision() {
        return this.defaultPrecision;
    }

    @Override
    public T setDefaultPrecision(Integer defaultPrecision) {
        this.defaultPrecision = defaultPrecision;
        return this.instance();
    }

    @Override
    public Integer getMaxPrecision() {
        return this.maxPrecision;
    }

    @Override
    public T setMaxPrecision(Integer maxPrecision) {
        this.maxPrecision = maxPrecision;
        this.getParent().addDataLength(this, Converters.getDefault().convertObject(maxPrecision, Long.class));
        return this.instance();
    }

    @Override
    public Integer getPrecision(Number precision) {
        return this.getProperNumber(this.getMaxPrecision(), this.getDefaultPrecision(), precision);
    }

    @Override
    protected void parseAndSet(Matcher matcher, DataTypeLengthProperties<?> column) {
        if (matcher.groupCount() == 0) {
            column.setLength(this.getDefaultPrecision());
        }
        if (matcher.groupCount() > 0) {
            String val = StringUtils.getGroupString(matcher, 1);
            Integer size = CommonUtils.toInteger(val);
            if (size != null) {
                column.setLength(CommonUtils.min(size, this.getMaxPrecision()));
            } else {
                column.setLength(this.getDefaultPrecision());
            }
        } else if (!CommonUtils.eqIgnoreCase(column.getDataTypeName(), this.getTypeName())) {
            SchemaUtils.setDataTypeNameInternal(this.getTypeName(), column);
        }
    }

    @Override
    public T addPrecisionFormat(String dataTypeName) {
        this.addFormats(dataTypeName + "\\s*\\(\\s*([0-9]+)\\s*\\)\\s*", dataTypeName + "\\s*");
        return (T)this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractPrecisionType)) {
            return false;
        }
        AbstractPrecisionType objValue = (AbstractPrecisionType)obj;
        if (!CommonUtils.eq(this.getDefaultPrecision(), objValue.getDefaultPrecision())) {
            return false;
        }
        return CommonUtils.eq(this.getMaxPrecision(), objValue.getMaxPrecision());
    }
}

