/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8DateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class YearMonthConverter
extends AbstractJava8DateConverter<YearMonth, YearMonthConverter>
implements NewValue<YearMonth> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public YearMonth convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (YearMonth)this.getDefaultValue();
        }
        if (value instanceof YearMonth) {
            return (YearMonth)value;
        }
        if (value instanceof Instant) {
            Instant cst = (Instant)Instant.class.cast(value);
            return this.toYearMonth(this.toZonedDateTime(cst));
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime cst = (LocalDateTime)LocalDateTime.class.cast(value);
            return this.toYearMonth(this.toZonedDateTime(cst));
        }
        if (value instanceof ChronoLocalDate) {
            ChronoLocalDate cst = (ChronoLocalDate)ChronoLocalDate.class.cast(value);
            return this.toYearMonth(this.toZonedDateTime(cst));
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime cst = (OffsetDateTime)OffsetDateTime.class.cast(value);
            return this.toYearMonth(this.toZonedDateTime(cst));
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime cst = (ZonedDateTime)ZonedDateTime.class.cast(value);
            return this.toYearMonth(this.toZonedDateTime(cst));
        }
        if (value instanceof Calendar) {
            Calendar cst = (Calendar)Calendar.class.cast(value);
            return this.toYearMonth(this.toZonedDateTime(cst));
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date cst = (java.sql.Date)java.sql.Date.class.cast(value);
            return this.toYearMonth(this.toZonedDateTime(cst.getTime()));
        }
        if (value instanceof Date) {
            Date cst = (Date)Date.class.cast(value);
            return this.toYearMonth(this.toZonedDateTime(cst.getTime()));
        }
        if (value instanceof Number) {
            return this.toYearMonth(this.toZonedDateTime((Number)value));
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (this.isCurrentText(lowerVal)) {
                return YearMonth.now();
            }
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return (YearMonth)this.parseDate(val.substring(1, val.length() - 1));
            }
            return (YearMonth)this.parseDate((String)value);
        }
        return (YearMonth)this.parseDate(value.toString());
    }

    public static YearMonthConverter newInstance() {
        YearMonthConverter dateConverter = new YearMonthConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof YearMonthConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public YearMonth newValue() {
        return YearMonth.now();
    }

    @Override
    protected YearMonth parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof YearMonth) {
            return (YearMonth)YearMonth.class.cast(temporal);
        }
        return this.toYearMonth(this.toZonedDateTime(temporal));
    }

    private YearMonth toYearMonth(ZonedDateTime zd) {
        return YearMonth.of(zd.getYear(), zd.getMonth());
    }

    @Override
    protected String format(YearMonth temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

