/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8DateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class YearConverter
extends AbstractJava8DateConverter<Year, YearConverter>
implements NewValue<Year> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public Year convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Year)this.getDefaultValue();
        }
        if (value instanceof Year) {
            return (Year)value;
        }
        if (value instanceof YearMonth) {
            YearMonth cst = (YearMonth)YearMonth.class.cast(value);
            return this.toYear(cst);
        }
        if (value instanceof Instant) {
            Instant cst = (Instant)Instant.class.cast(value);
            return this.toYear(this.toZonedDateTime(cst));
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime cst = (LocalDateTime)LocalDateTime.class.cast(value);
            return this.toYear(this.toZonedDateTime(cst));
        }
        if (value instanceof ChronoLocalDate) {
            ChronoLocalDate cst = (ChronoLocalDate)ChronoLocalDate.class.cast(value);
            return this.toYear(this.toZonedDateTime(cst));
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime cst = (OffsetDateTime)OffsetDateTime.class.cast(value);
            return this.toYear(this.toZonedDateTime(cst));
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime cst = (ZonedDateTime)ZonedDateTime.class.cast(value);
            return this.toYear(this.toZonedDateTime(cst));
        }
        if (value instanceof Calendar) {
            Calendar cst = (Calendar)Calendar.class.cast(value);
            return this.toYear(this.toZonedDateTime(cst));
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date cst = (java.sql.Date)java.sql.Date.class.cast(value);
            return this.toYear(this.toZonedDateTime(cst.getTime()));
        }
        if (value instanceof Date) {
            Date cst = (Date)Date.class.cast(value);
            return this.toYear(this.toZonedDateTime(cst.getTime()));
        }
        if (value instanceof Number) {
            return this.toYear(this.toZonedDateTime((Number)value));
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (this.isCurrentText(lowerVal)) {
                return Year.now();
            }
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return (Year)this.parseDate(val.substring(1, val.length() - 1));
            }
            return (Year)this.parseDate((String)value);
        }
        return (Year)this.parseDate(value.toString());
    }

    public static YearConverter newInstance() {
        YearConverter dateConverter = new YearConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof YearConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Year newValue() {
        return Year.now();
    }

    @Override
    protected Year parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof Year) {
            return (Year)Year.class.cast(temporal);
        }
        return Year.of(temporal.get(ChronoField.YEAR));
    }

    private Year toYear(ZonedDateTime zd) {
        return Year.of(zd.getYear());
    }

    private Year toYear(YearMonth zd) {
        return Year.of(zd.getYear());
    }

    @Override
    protected String format(Year temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

