/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractDateConverter;
import com.sqlapp.data.converter.AbstractJava8DateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.Calendar;
import java.util.Date;

public class TimeConverter
extends AbstractDateConverter<Time, TimeConverter>
implements NewValue<Time> {
    private static final long serialVersionUID = 8032929431592968750L;

    @Override
    public Time convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Time)this.getDefaultValue();
        }
        if (value instanceof Time) {
            return (Time)Time.class.cast(value);
        }
        if (value instanceof Date) {
            return DateUtils.toTime((Date)value);
        }
        if (value instanceof Instant) {
            return DateUtils.toTime(Time.from((Instant)value));
        }
        if (value instanceof ChronoLocalDate) {
            return DateUtils.toTime(Time.from(Instant.EPOCH));
        }
        if (value instanceof LocalTime) {
            LocalTime localTime = (LocalTime)LocalTime.class.cast(value);
            return Time.valueOf(localTime);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)LocalDateTime.class.cast(value);
            return Time.valueOf(localDateTime.toLocalTime());
        }
        if (value instanceof OffsetDateTime) {
            LocalTime localTime = ((OffsetDateTime)value).toLocalTime();
            return Time.valueOf(localTime);
        }
        if (value instanceof ZonedDateTime) {
            LocalTime localTime = ((ZonedDateTime)value).toLocalTime();
            return Time.valueOf(localTime);
        }
        if (value instanceof Calendar) {
            return DateUtils.toTime((Calendar)value);
        }
        if (value instanceof Long) {
            return DateUtils.toTime((Long)value);
        }
        ZonedDateTime zonedDateTime = this.getZonedDateTimeConverter().convertObject(value);
        return this.toTime(zonedDateTime);
    }

    private Time toTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        Time time = new Time(dateTime.withZoneSameInstant(AbstractJava8DateConverter.INSTANT_ZONE_ID).withYear(1970).withMonth(1).withDayOfMonth(1).toInstant().toEpochMilli());
        return time;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof TimeConverter;
    }

    @Override
    public Time copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Time)this.convertObject(obj).clone();
    }

    @Override
    public Time newValue() {
        return DateUtils.toTime(System.currentTimeMillis());
    }
}

