/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;

public class StringConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = -7755839975092182747L;
    private Converters converters = null;
    private boolean useIntern = false;

    public StringConverter() {
    }

    public StringConverter(Converters converters) {
        this.converters = converters;
    }

    public StringConverter setConverters(Converters converters) {
        this.converters = converters;
        return this;
    }

    @Override
    public String convertObject(Object value) {
        if (value == null) {
            return (String)this.getDefaultValue();
        }
        if (value instanceof String) {
            return this.internString((String)value);
        }
        if (value instanceof Reader) {
            Reader reader = (Reader)CommonUtils.cast(value);
            return FileUtils.read(reader);
        }
        if (value instanceof Clob) {
            Clob lob = (Clob)value;
            try {
                return lob.getSubString(1L, (int)lob.length());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof SQLXML) {
            SQLXML sqlxml = (SQLXML)value;
            try {
                String e = sqlxml.getString();
                return e;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    sqlxml.free();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (this.converters != null) {
            return this.internString(this.converters.convertString(value, value.getClass()));
        }
        return this.internString(value.toString());
    }

    private String internString(String value) {
        if (this.useIntern) {
            return value.intern();
        }
        return value;
    }

    @Override
    public String convertString(String value) {
        return this.internString(value);
    }

    public boolean isUseIntern() {
        return this.useIntern;
    }

    public void setUseIntern(boolean useIntern) {
        this.useIntern = useIntern;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StringConverter)) {
            return false;
        }
        StringConverter con = (StringConverter)CommonUtils.cast(obj);
        if (!CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue())) {
            return false;
        }
        return CommonUtils.eq(this.useIntern, con.useIntern);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public String copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }
}

