/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractNumberConverter;
import com.sqlapp.util.CommonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ShortConverter
extends AbstractNumberConverter<Short> {
    private static final long serialVersionUID = -7210830756251120344L;
    protected static final Short ZERO = 0;
    private static final Short ONE = 1;

    @Override
    public Short convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Short)this.getDefaultValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return this.convert(this.trim((String)value));
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ONE;
            }
            return ZERO;
        }
        if (value instanceof byte[]) {
            return ShortConverter.toShort((byte[])value);
        }
        return this.convert(value.toString());
    }

    private Short convert(String value) {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return Short.valueOf(value);
        }
        return this.parse(value).shortValue();
    }

    @Override
    public String convertString(Short value) {
        if (value == null) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return value.toString();
        }
        return this.format(value);
    }

    public static short toShort(byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.wrap(bytes);
        keyBuffer.order(ByteOrder.BIG_ENDIAN);
        return keyBuffer.getShort();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof ShortConverter)) {
            return false;
        }
        ShortConverter con = (ShortConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Short copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    protected boolean getParseIntegerOnly() {
        return true;
    }
}

