/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Point3D;
import com.sqlapp.util.CommonUtils;

public class PointConverter
extends AbstractConverter<Point>
implements NewValue<Point> {
    private static final long serialVersionUID = -7480426186864635353L;

    @Override
    public Point convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Point)this.getDefaultValue();
        }
        if (value instanceof Point) {
            return (Point)value;
        }
        if (value instanceof Point3D) {
            return ((Point3D)value).toLowerDimension();
        }
        if (value instanceof java.awt.Point) {
            java.awt.Point ap = (java.awt.Point)value;
            return new Point(ap.getX(), ap.getY());
        }
        Point obj = new Point();
        obj.setValue(value.toString());
        return obj;
    }

    @Override
    public String convertString(Point value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PointConverter)) {
            return false;
        }
        PointConverter con = (PointConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Point copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    public Point newValue() {
        return new Point();
    }
}

