/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.data.geometry.Path;
import com.sqlapp.data.geometry.Path3D;
import com.sqlapp.data.geometry.Polygon;
import com.sqlapp.data.geometry.Polygon3D;
import com.sqlapp.util.CommonUtils;

public class PathConverter
extends AbstractConverter<Path>
implements NewValue<Path> {
    private static final long serialVersionUID = -7480426186864635353L;

    @Override
    public Path convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Path)this.getDefaultValue();
        }
        if (value instanceof Path) {
            return (Path)value;
        }
        if (value instanceof Path3D) {
            return ((Path3D)value).toLowerDimension();
        }
        if (value instanceof Polygon) {
            return ((Polygon)value).toPath();
        }
        if (value instanceof Polygon3D) {
            return ((Polygon3D)value).toPath().toLowerDimension();
        }
        Path obj = new Path();
        obj.setValue(value.toString());
        return obj;
    }

    @Override
    public String convertString(Path value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PathConverter)) {
            return false;
        }
        PathConverter con = (PathConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Path copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    public Path newValue() {
        return new Path();
    }
}

