/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.CommonUtils;
import java.math.BigDecimal;

public class NumberConverter
extends AbstractConverter<Number> {
    private static final long serialVersionUID = -7755839975092182747L;
    private Converters converters = null;
    private Class<? extends Number> defaultClass = BigDecimal.class;

    public NumberConverter() {
    }

    public NumberConverter(Converters converters) {
        this.converters = converters;
    }

    public NumberConverter setConverters(Converters converters) {
        this.converters = converters;
        return this;
    }

    @Override
    public Number convertObject(Object value) {
        if (value == null) {
            return (Number)this.getDefaultValue();
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        return this.converters.convertObject(value, this.defaultClass);
    }

    public Class<? extends Number> getDefaultClass() {
        return this.defaultClass;
    }

    public NumberConverter setDefaultClass(Class<? extends Number> defaultClass) {
        this.defaultClass = defaultClass;
        return this;
    }

    @Override
    public String convertString(Number value) {
        if (value == null) {
            return null;
        }
        return this.converters.convertString(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumberConverter)) {
            return false;
        }
        NumberConverter con = (NumberConverter)CommonUtils.cast(obj);
        if (!CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue())) {
            return false;
        }
        return CommonUtils.eq(this.getDefaultClass(), con.getDefaultClass());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Number copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }
}

