/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractNumberConverter;
import com.sqlapp.util.CommonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class LongConverter
extends AbstractNumberConverter<Long> {
    private static final long serialVersionUID = 1528710143236683674L;
    protected static final Long ZERO = 0L;
    private static final Long ONE = 1L;

    @Override
    public Long convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Long)this.getDefaultValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof OptionalInt) {
            OptionalInt op = (OptionalInt)value;
            return op.isPresent() ? Long.valueOf(op.getAsInt()) : null;
        }
        if (value instanceof OptionalLong) {
            OptionalLong op = (OptionalLong)value;
            return op.isPresent() ? Long.valueOf(op.getAsLong()) : null;
        }
        if (value instanceof OptionalDouble) {
            OptionalDouble op = (OptionalDouble)value;
            return op.isPresent() ? Long.valueOf((long)op.getAsDouble()) : null;
        }
        if (value instanceof String) {
            return this.convert(this.trim((String)value));
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ONE;
            }
            return ZERO;
        }
        if (value instanceof byte[]) {
            return LongConverter.toLong((byte[])value);
        }
        return this.convert(value.toString());
    }

    private Long convert(String value) {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return Long.valueOf(value);
        }
        return this.parse(value).longValue();
    }

    @Override
    public String convertString(Long value) {
        if (value == null) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return value.toString();
        }
        return this.format(value);
    }

    public static long toLong(byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.wrap(bytes);
        keyBuffer.order(ByteOrder.BIG_ENDIAN);
        return keyBuffer.getLong();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof LongConverter)) {
            return false;
        }
        LongConverter con = (LongConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Long copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }

    @Override
    protected boolean getParseIntegerOnly() {
        return true;
    }
}

