/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8DateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class LocalDateTimeConverter
extends AbstractJava8DateConverter<LocalDateTime, LocalDateTimeConverter>
implements NewValue<LocalDateTime> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public LocalDateTime convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (LocalDateTime)this.getDefaultValue();
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof Instant) {
            Instant ins = (Instant)Instant.class.cast(value);
            return this.toZonedDateTime(ins).toLocalDateTime();
        }
        if (value instanceof ChronoLocalDate) {
            return this.toZonedDateTime((ChronoLocalDate)value).toLocalDateTime();
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toLocalDateTime();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        if (value instanceof Calendar) {
            Calendar cal = (Calendar)Calendar.class.cast(value);
            return this.toZonedDateTime(cal).toLocalDateTime();
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
            return this.toZonedDateTime(Instant.ofEpochMilli(dt.getTime())).toLocalDateTime();
        }
        if (value instanceof Date) {
            Date dt = (Date)Date.class.cast(value);
            return this.toZonedDateTime(dt.toInstant()).toLocalDateTime();
        }
        if (value instanceof Number) {
            return this.toZonedDateTime((Number)value).toLocalDateTime();
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (this.isCurrentText(lowerVal)) {
                return LocalDateTime.now();
            }
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return (LocalDateTime)this.parseDate(val.substring(1, val.length() - 1));
            }
            if (this.isNumberPattern(lowerVal)) {
                Instant ins = this.toInstant(lowerVal);
                return this.toZonedDateTime(ins).toLocalDateTime();
            }
            return (LocalDateTime)this.parseDate((String)value);
        }
        return (LocalDateTime)this.parseDate(value.toString());
    }

    public static LocalDateTimeConverter newInstance() {
        LocalDateTimeConverter dateConverter = new LocalDateTimeConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof LocalDateTimeConverter;
    }

    @Override
    public LocalDateTime newValue() {
        return LocalDateTime.now();
    }

    @Override
    protected LocalDateTime parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof LocalDateTime) {
            return (LocalDateTime)LocalDateTime.class.cast(temporal);
        }
        return this.toZonedDateTime(temporal).toLocalDateTime();
    }

    @Override
    protected String format(LocalDateTime temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

