/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalYearToDay;
import com.sqlapp.util.CommonUtils;

public class IntervalYearToDayConverter
extends AbstractConverter<IntervalYearToDay> {
    private static final long serialVersionUID = -6761994480513436531L;

    @Override
    public IntervalYearToDay convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (IntervalYearToDay)this.getDefaultValue();
        }
        if (value instanceof IntervalYearToDay) {
            return (IntervalYearToDay)value;
        }
        if (value instanceof Interval) {
            return IntervalYearToDay.toYearToDayType((Interval)value);
        }
        if (value instanceof String) {
            return IntervalYearToDay.parse((String)value);
        }
        return this.convert(value.toString());
    }

    private IntervalYearToDay convert(String value) {
        return IntervalYearToDay.parse(value);
    }

    @Override
    public String convertString(IntervalYearToDay value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntervalYearToDayConverter)) {
            return false;
        }
        IntervalYearToDayConverter con = (IntervalYearToDayConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public IntervalYearToDay copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj).clone();
    }
}

