/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalMonth;
import com.sqlapp.util.CommonUtils;

public class IntervalMonthConverter
extends AbstractConverter<IntervalMonth> {
    private static final long serialVersionUID = -1050734373259054536L;

    @Override
    public IntervalMonth convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (IntervalMonth)this.getDefaultValue();
        }
        if (value instanceof IntervalMonth) {
            return (IntervalMonth)value;
        }
        if (value instanceof Interval) {
            return IntervalMonth.toMonthType((Interval)value);
        }
        if (value instanceof String) {
            return IntervalMonth.parse((String)value);
        }
        return this.convert(value.toString());
    }

    private IntervalMonth convert(String value) {
        return IntervalMonth.parse(value);
    }

    @Override
    public String convertString(IntervalMonth value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntervalMonthConverter)) {
            return false;
        }
        IntervalMonthConverter con = (IntervalMonthConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public IntervalMonth copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj).clone();
    }
}

