/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.LocalTimeConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.time.Duration;
import java.time.LocalTime;
import java.time.chrono.ChronoPeriod;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class DurationConverter
extends AbstractConverter<Duration>
implements NewValue<Duration> {
    private static final long serialVersionUID = 1212274814940098554L;
    private static LocalTimeConverter LOCAL_TIME_CONVERTER = new LocalTimeConverter();

    @Override
    public Duration convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Duration)this.getDefaultValue();
        }
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value instanceof ChronoPeriod) {
            ChronoPeriod cst = (ChronoPeriod)ChronoPeriod.class.cast(value);
            return Duration.from(cst);
        }
        if (value instanceof Temporal) {
            LocalTime localDate = LOCAL_TIME_CONVERTER.convertObject(value);
            return Duration.ofSeconds(localDate.getSecond(), localDate.getNano());
        }
        if (value instanceof Calendar) {
            Calendar cst = (Calendar)Calendar.class.cast(value);
            return Duration.ofSeconds(this.toSecond(cst), this.toNano(cst));
        }
        if (value instanceof Date) {
            java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
            Calendar cst = DateUtils.toCalendar(dt);
            return Duration.ofSeconds(this.toSecond(cst), this.toNano(cst));
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return this.parse(val.substring(1, val.length() - 1));
            }
            return this.parse((String)value);
        }
        return this.parse(value.toString());
    }

    private long toNano(Calendar cst) {
        return cst.get(14) * 1000000;
    }

    private long toSecond(Calendar cst) {
        long val = cst.get(13) + cst.get(12) * 60 + cst.get(11) * 3600;
        return val;
    }

    private long toSecond(long hour, long minute, long second) {
        long val = second + minute * 60L + hour * 3600L;
        return val;
    }

    public static DurationConverter newInstance() {
        DurationConverter dateConverter = new DurationConverter();
        return dateConverter;
    }

    private Duration parse(String text) {
        try {
            return Duration.parse(text);
        }
        catch (DateTimeParseException e) {
            Interval interval = Interval.parse(text);
            return Duration.ofSeconds(this.toSecond(interval.getHours(), interval.getMinutes(), interval.getSeconds()), interval.getNanos());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof DurationConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Duration newValue() {
        return Duration.ofNanos(0L);
    }

    @Override
    public Duration copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Duration)obj;
    }
}

