/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractNumberConverter;
import com.sqlapp.util.CommonUtils;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class ByteConverter
extends AbstractNumberConverter<Byte> {
    private static final long serialVersionUID = -4231103865018471812L;
    protected static final Byte ZERO = 0;
    private static final Byte ONE = 1;

    @Override
    public Byte convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Byte)this.getDefaultValue();
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return this.convert(this.trim((String)value));
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof OptionalInt) {
            OptionalInt op = (OptionalInt)value;
            return op.isPresent() ? Byte.valueOf(Integer.valueOf(op.getAsInt()).byteValue()) : null;
        }
        if (value instanceof OptionalLong) {
            OptionalLong op = (OptionalLong)value;
            return op.isPresent() ? Byte.valueOf(Long.valueOf(op.getAsLong()).byteValue()) : null;
        }
        if (value instanceof OptionalDouble) {
            OptionalDouble op = (OptionalDouble)value;
            return op.isPresent() ? Byte.valueOf(Double.valueOf(op.getAsDouble()).byteValue()) : null;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ONE;
            }
            return ZERO;
        }
        return this.convert(value.toString());
    }

    private Byte convert(String value) {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return Byte.valueOf(value);
        }
        return this.parse(value).byteValue();
    }

    @Override
    public String convertString(Byte value) {
        if (value == null) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return value.toString();
        }
        return this.format(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(this)) {
            return false;
        }
        return obj instanceof ByteConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Byte copy(Object obj) {
        return this.convertObject(obj);
    }

    @Override
    protected boolean getParseIntegerOnly() {
        return true;
    }
}

