/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractNumberConverter;
import com.sqlapp.util.CommonUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class BigIntegerConverter
extends AbstractNumberConverter<BigInteger> {
    private static final long serialVersionUID = 775619452908753182L;

    @Override
    public BigInteger convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (BigInteger)this.getDefaultValue();
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof String) {
            return this.convert(((String)value).trim());
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof OptionalInt) {
            OptionalInt op = (OptionalInt)value;
            return op.isPresent() ? BigInteger.valueOf(op.getAsInt()) : null;
        }
        if (value instanceof OptionalLong) {
            OptionalLong op = (OptionalLong)value;
            return op.isPresent() ? BigInteger.valueOf(op.getAsLong()) : null;
        }
        if (value instanceof OptionalDouble) {
            OptionalDouble op = (OptionalDouble)value;
            return op.isPresent() ? BigInteger.valueOf((long)op.getAsDouble()) : null;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return BigInteger.ONE;
            }
            return BigInteger.ZERO;
        }
        return this.convert(value.toString());
    }

    private BigInteger convert(String value) {
        if (this.getNumberFormat() == null) {
            return new BigInteger(value);
        }
        DecimalFormat format = (DecimalFormat)this.getNumberFormat();
        format.setParseBigDecimal(true);
        return ((BigDecimal)this.parse(value)).toBigInteger();
    }

    @Override
    public String convertString(BigInteger value) {
        if (value == null) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return value.toString();
        }
        return this.format(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(this)) {
            return false;
        }
        return obj instanceof BigIntegerConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public BigInteger copy(Object obj) {
        return this.convertObject(obj);
    }

    @Override
    protected boolean getParseIntegerOnly() {
        return true;
    }
}

