/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.ZonedDateTimeConverter;
import com.sqlapp.util.CommonUtils;
import java.time.ZonedDateTime;

public abstract class AbstractDateConverter<T, S>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1212274814940098554L;
    private ZonedDateTimeConverter zonedDateTimeConverter = null;

    public ZonedDateTimeConverter getZonedDateTimeConverter() {
        return this.zonedDateTimeConverter;
    }

    public S setZonedDateTimeConverter(ZonedDateTimeConverter zonedDateTimeConverter) {
        this.zonedDateTimeConverter = zonedDateTimeConverter;
        return this.instance();
    }

    protected S instance() {
        return (S)this;
    }

    @Override
    public String convertString(T value) {
        if (value == null) {
            return null;
        }
        return this.convertStringInternal(value);
    }

    protected String convertStringInternal(Object value) {
        if (value == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = this.getZonedDateTimeConverter().convertObject(value);
        String ret = this.getZonedDateTimeConverter().convertString(zonedDateTime);
        return ret;
    }

    protected static ZonedDateTimeConverter newZonedDateTimeConverter(Object ... formats) {
        ZonedDateTimeConverter dateTimeConverter = new ZonedDateTimeConverter();
        dateTimeConverter.setParseFormats(formats);
        return dateTimeConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractDateConverter)) {
            return false;
        }
        AbstractDateConverter cst = (AbstractDateConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getZonedDateTimeConverter(), cst.getZonedDateTimeConverter());
    }
}

