/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.exceptions.SqlappDataConversionException;
import com.sqlapp.util.CommonUtils;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractArrayConverter<T, S>
implements Converter<T> {
    private final Converter<S> unitConverter;
    private T defaultObject = null;

    protected AbstractArrayConverter(Converter<S> unitConverter) {
        this.unitConverter = unitConverter;
    }

    @Override
    public T convertObject(Object value) {
        return this.convertObject(value, null);
    }

    @Override
    public T convertObject(Object value, Connection conn) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            T array = this.newArrayInstance(size);
            for (int i = 0; i < size; ++i) {
                Object obj = Array.get(value, i);
                this.setArray(array, i, this.unitConverter.convertObject(obj, conn));
            }
            return array;
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            T array = this.newArrayInstance(c.size());
            int i = 0;
            for (Object obj : c) {
                this.setArray(array, i, this.unitConverter.convertObject(obj, conn));
                ++i;
            }
            return array;
        }
        if (value instanceof Iterable) {
            Iterable c = (Iterable)value;
            List list = CommonUtils.list();
            for (Object obj : c) {
                list.add(this.unitConverter.convertObject(obj, conn));
            }
            T array = this.newArrayInstance(list.size());
            System.arraycopy(list.toArray(), 0, array, 0, list.size());
            return array;
        }
        if (value instanceof java.sql.Array) {
            T t;
            java.sql.Array c = (java.sql.Array)value;
            try {
                Object arr = c.getArray();
                int size = Array.getLength(arr);
                T array = this.newArrayInstance(size);
                for (int i = 0; i < size; ++i) {
                    Object obj = Array.get(value, i);
                    this.setArray(array, i, this.unitConverter.convertObject(obj, conn));
                }
                t = array;
            }
            catch (SQLException e) {
                throw new SqlappDataConversionException(e);
            }
            finally {
                try {
                    c.free();
                }
                catch (SQLException sQLException) {}
            }
            return t;
        }
        T array = this.newArrayInstance(1);
        this.setArray(array, 0, this.unitConverter.convertObject(value, conn));
        return array;
    }

    protected void setArray(T array, int i, S value) {
        Array.set(array, i, value);
    }

    public Converter<S> getUnitConverter() {
        return this.unitConverter;
    }

    @Override
    public T getDefaultValue() {
        return this.copy(this.defaultObject);
    }

    @Override
    public Converter<T> setDefaultValue(T defaultObject) {
        this.defaultObject = defaultObject;
        return this;
    }

    @Override
    public String convertString(T value) {
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            return null;
        }
        Object[] arr = (Object[])value;
        return Arrays.deepToString(arr);
    }

    @Override
    public T copy(Object value) {
        return this.convertObject(value);
    }

    protected abstract T newArrayInstance(int var1);
}

