/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPair;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class VirticaForeignKeyConstraintReader
extends ForeignKeyConstraintReader {
    public VirticaForeignKeyConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<ForeignKeyConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List list = CommonUtils.list();
        final TripleKeyMap tCMap = CommonUtils.tripleKeyMap();
        final TripleKeyMap tColMap = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Object pk_table_catalog = null;
                String pk_table_schema = this.getString(rs, "REFERENCE_TABLE_SCHEMA");
                String pk_table_name = this.getString(rs, "REFERENCE_TABLE_NAME");
                String pk_columnName = this.getString(rs, "REFERENCE_COLUMN_NAME");
                String fk_table_catalog = null;
                String fk_table_schema = this.getString(rs, "TABLE_SCHEMA");
                String fk_table_name = this.getString(rs, "table_name");
                String fk_columnName = this.getString(rs, "column_name");
                String fk_name = this.getString(rs, "constraint_name");
                ForeignKeyConstraint c = (ForeignKeyConstraint)tCMap.get(fk_table_catalog, (Object)fk_table_schema, (Object)fk_name);
                FlexList colList = (FlexList)tColMap.get(fk_table_catalog, (Object)fk_table_schema, (Object)fk_name);
                if (c == null) {
                    c = new ForeignKeyConstraint(fk_name);
                    c.setCatalogName(fk_table_catalog);
                    c.setSchemaName(fk_table_schema);
                    c.setTableName(fk_table_name);
                    colList = new FlexList();
                    tCMap.put(fk_table_catalog, (Object)fk_table_schema, (Object)fk_name, (Object)c);
                    tColMap.put(fk_table_catalog, (Object)fk_table_schema, (Object)fk_name, (Object)colList);
                    list.add(c);
                }
                ColumnPair cPair = new ColumnPair();
                cPair.refCatalogName = pk_table_catalog;
                cPair.refSchemaName = pk_table_schema;
                cPair.refTableName = pk_table_name;
                cPair.refColumnName = pk_columnName;
                cPair.columnName = fk_columnName;
                colList.add((Object)cPair);
            }
        });
        this.setForeignKeyConstraintColumns(tColMap, list);
        return list;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("foreignKeyConstraints.sql");
    }
}

