/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.virtica.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class VirticaColumnReader
extends ColumnReader {
    public VirticaColumnReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Column> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Column obj = VirticaColumnReader.this.createColumn(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected Column createColumn(ExResultSet rs) throws SQLException {
        Column obj = new Column(this.getString((ResultSet)rs, "column_name"));
        boolean nullable = this.toBoolean(this.getString((ResultSet)rs, "IS_NULLABLE"));
        String data_type = this.getString((ResultSet)rs, "DATA_TYPE");
        boolean identity = this.toBoolean(this.getString((ResultSet)rs, "IS_IDENTITY"));
        Long char_maxlength = this.getLong((ResultSet)rs, "CHARACTER_MAXIMUM_LENGTH");
        Long numeric_precision = this.getLong((ResultSet)rs, "NUMERIC_PRECISION");
        Integer numeric_scale = this.getInteger((ResultSet)rs, "NUMERIC_SCALE");
        Integer datetime_precision = this.getInteger((ResultSet)rs, "DATETIME_PRECISION");
        obj.setNullable(nullable);
        obj.setIdentity(identity);
        if (identity) {
            obj.setSequenceName(this.getString((ResultSet)rs, "SEQUENCE_NAME"));
        }
        this.getDialect().setDbType(data_type, Long.valueOf(CommonUtils.max((long)char_maxlength, (long)numeric_precision, (long)datetime_precision.intValue())), numeric_scale, (DataTypeLengthProperties)obj);
        obj.setDefaultValue(this.getString((ResultSet)rs, "COLUMN_DEFAULT"));
        obj.setCatalogName(this.getString((ResultSet)rs, "table_catalog"));
        obj.setSchemaName(this.getString((ResultSet)rs, "table_schema"));
        obj.setTableName(this.getString((ResultSet)rs, "table_name"));
        obj.setRemarks(this.getString((ResultSet)rs, "COMMENT"));
        return obj;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("columns.sql");
    }
}

