/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.writer;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.charset.Charset;

public abstract class Writer {
    protected final URI uri;
    protected final Charset charset;

    public static Writer from(URI uri, Charset charset) {
        String className = Writer.writerClassNameFrom(uri);
        try {
            Class<?> theClass = Class.forName(className);
            Constructor<?> constructor = theClass.getConstructor(URI.class, Charset.class);
            return (Writer)constructor.newInstance(uri, charset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Couldn't find the '%s' writer.", className), e);
        }
    }

    protected Writer(URI uri, Charset charset) {
        this.uri = uri;
        this.charset = charset;
    }

    public abstract void write(String var1);

    private static String writerClassNameFrom(URI uri) {
        if (Writer.isNotDefined(uri.getScheme()) && Writer.isDefined(uri.getPath())) {
            return Writer.toFullClassName(uri.getPath());
        }
        if (Writer.isDefined(uri.getScheme())) {
            return Writer.toFullClassName(uri.getScheme());
        }
        throw new IllegalArgumentException(String.format("Couldn't derive a Writer name from uri: '%s'.", uri.toString()));
    }

    private static String toFullClassName(String writerClass) {
        return String.format("com.smartcodeltd.writer.To%s%s", Character.valueOf(Character.toUpperCase(writerClass.charAt(0))), writerClass.substring(1));
    }

    private static boolean isDefined(String value) {
        return value != null && !value.isEmpty();
    }

    private static boolean isNotDefined(String value) {
        return !Writer.isDefined(value);
    }
}

