/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.core5.util;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.annotation.Contract;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import java.util.BitSet;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class Tokenizer {
    public static final char DQUOTE = '\"';
    public static final char ESCAPE = '\\';
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int SP = 32;
    public static final int HT = 9;
    public static final Tokenizer INSTANCE = new Tokenizer();

    @Deprecated
    public static BitSet INIT_BITSET(int ... b) {
        BitSet bitset = new BitSet();
        for (int aB : b) {
            bitset.set(aB);
        }
        return bitset;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public static Delimiter delimiters(BitSet delimiters) {
        return delimiters::get;
    }

    public static Delimiter delimiters(char ... delimiters) {
        return ch -> {
            for (char delimiter : delimiters) {
                if (delimiter != ch) continue;
                return true;
            }
            return false;
        };
    }

    public static Delimiter delimiters(char delimiter) {
        return ch -> ch == delimiter;
    }

    public static Delimiter delimiters(char delimiter1, char delimiter2) {
        return ch -> ch == delimiter1 || ch == delimiter2;
    }

    public static Delimiter delimiters(char delimiter1, char delimiter2, char delimiter3) {
        return ch -> ch == delimiter1 || ch == delimiter2 || ch == delimiter3;
    }

    public String parseContent(CharSequence buf, Cursor cursor, Delimiter delimiterPredicate) {
        Args.notNull(buf, "Char sequence");
        Args.notNull(cursor, "Parser cursor");
        StringBuilder dst = new StringBuilder();
        this.copyContent(buf, cursor, delimiterPredicate, dst);
        return dst.toString();
    }

    @Deprecated
    public String parseContent(CharSequence buf, Cursor cursor, BitSet bitSet) {
        return this.parseContent(buf, cursor, bitSet != null ? bitSet::get : null);
    }

    public String parseToken(CharSequence buf, Cursor cursor, Delimiter delimiterPredicate) {
        Args.notNull(buf, "Char sequence");
        Args.notNull(cursor, "Parser cursor");
        StringBuilder dst = new StringBuilder();
        boolean whitespace = false;
        while (!cursor.atEnd()) {
            char current = buf.charAt(cursor.getPos());
            if (delimiterPredicate != null && delimiterPredicate.test(current)) break;
            if (Tokenizer.isWhitespace(current)) {
                this.skipWhiteSpace(buf, cursor);
                whitespace = true;
                continue;
            }
            if (whitespace && dst.length() > 0) {
                dst.append(' ');
            }
            this.copyContent(buf, cursor, delimiterPredicate, dst);
            whitespace = false;
        }
        return dst.toString();
    }

    @Deprecated
    public String parseToken(CharSequence buf, Cursor cursor, BitSet bitSet) {
        return this.parseToken(buf, cursor, bitSet != null ? bitSet::get : null);
    }

    public String parseValue(CharSequence buf, Cursor cursor, Delimiter delimiterPredicate) {
        Args.notNull(buf, "Char sequence");
        Args.notNull(cursor, "Parser cursor");
        StringBuilder dst = new StringBuilder();
        boolean whitespace = false;
        while (!cursor.atEnd()) {
            char current = buf.charAt(cursor.getPos());
            if (delimiterPredicate != null && delimiterPredicate.test(current)) break;
            if (Tokenizer.isWhitespace(current)) {
                this.skipWhiteSpace(buf, cursor);
                whitespace = true;
                continue;
            }
            if (current == '\"') {
                if (whitespace && dst.length() > 0) {
                    dst.append(' ');
                }
                this.copyQuotedContent(buf, cursor, dst);
                whitespace = false;
                continue;
            }
            if (whitespace && dst.length() > 0) {
                dst.append(' ');
            }
            this.copyUnquotedContent(buf, cursor, delimiterPredicate, dst);
            whitespace = false;
        }
        return dst.toString();
    }

    @Deprecated
    public String parseValue(CharSequence buf, Cursor cursor, BitSet bitSet) {
        return this.parseValue(buf, cursor, bitSet != null ? bitSet::get : null);
    }

    public void skipWhiteSpace(CharSequence buf, Cursor cursor) {
        char current;
        Args.notNull(buf, "Char sequence");
        Args.notNull(cursor, "Parser cursor");
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i = indexFrom; i < indexTo && Tokenizer.isWhitespace(current = buf.charAt(i)); ++i) {
            ++pos;
        }
        cursor.updatePos(pos);
    }

    public void copyContent(CharSequence buf, Cursor cursor, Delimiter delimiterPredicate, StringBuilder dst) {
        Args.notNull(buf, "Char sequence");
        Args.notNull(cursor, "Parser cursor");
        Args.notNull(dst, "String builder");
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i = indexFrom; i < indexTo; ++i) {
            char current = buf.charAt(i);
            if (delimiterPredicate != null && delimiterPredicate.test(current) || Tokenizer.isWhitespace(current)) break;
            ++pos;
            dst.append(current);
        }
        cursor.updatePos(pos);
    }

    @Deprecated
    public void copyContent(CharSequence buf, Cursor cursor, BitSet bitSet, StringBuilder dst) {
        this.copyContent(buf, cursor, bitSet != null ? bitSet::get : null, dst);
    }

    public void copyUnquotedContent(CharSequence buf, Cursor cursor, Delimiter delimiterPredicate, StringBuilder dst) {
        Args.notNull(buf, "Char sequence");
        Args.notNull(cursor, "Parser cursor");
        Args.notNull(dst, "String builder");
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i = indexFrom; i < indexTo; ++i) {
            char current = buf.charAt(i);
            if (delimiterPredicate != null && delimiterPredicate.test(current) || Tokenizer.isWhitespace(current) || current == '\"') break;
            ++pos;
            dst.append(current);
        }
        cursor.updatePos(pos);
    }

    @Deprecated
    public void copyUnquotedContent(CharSequence buf, Cursor cursor, BitSet bitSet, StringBuilder dst) {
        this.copyUnquotedContent(buf, cursor, bitSet != null ? bitSet::get : null, dst);
    }

    public void copyQuotedContent(CharSequence buf, Cursor cursor, StringBuilder dst) {
        Args.notNull(buf, "Char sequence");
        Args.notNull(cursor, "Parser cursor");
        Args.notNull(dst, "String builder");
        if (cursor.atEnd()) {
            return;
        }
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        char current = buf.charAt(pos);
        if (current != '\"') {
            return;
        }
        ++pos;
        boolean escaped = false;
        int i = ++indexFrom;
        while (i < indexTo) {
            current = buf.charAt(i);
            if (escaped) {
                if (current != '\"' && current != '\\') {
                    dst.append('\\');
                }
                dst.append(current);
                escaped = false;
            } else {
                if (current == '\"') {
                    ++pos;
                    break;
                }
                if (current == '\\') {
                    escaped = true;
                } else if (current != '\r' && current != '\n') {
                    dst.append(current);
                }
            }
            ++i;
            ++pos;
        }
        cursor.updatePos(pos);
    }

    @FunctionalInterface
    public static interface Delimiter {
        public boolean test(char var1);
    }

    public static class Cursor {
        private final int lowerBound;
        private final int upperBound;
        private int pos;

        public Cursor(int lowerBound, int upperBound) {
            Args.notNegative(lowerBound, "lowerBound");
            Args.check(lowerBound <= upperBound, "lowerBound cannot be greater than upperBound");
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.pos = lowerBound;
        }

        public int getLowerBound() {
            return this.lowerBound;
        }

        public int getUpperBound() {
            return this.upperBound;
        }

        public int getPos() {
            return this.pos;
        }

        public void updatePos(int pos) {
            Args.check(pos >= this.lowerBound, "pos: %s < lowerBound: %s", pos, this.lowerBound);
            Args.check(pos <= this.upperBound, "pos: %s > upperBound: %s", pos, this.upperBound);
            this.pos = pos;
        }

        public boolean atEnd() {
            return this.pos >= this.upperBound;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('[');
            buffer.append(this.lowerBound);
            buffer.append('>');
            buffer.append(this.pos);
            buffer.append('>');
            buffer.append(this.upperBound);
            buffer.append(']');
            return buffer.toString();
        }
    }
}

