/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.core5.http2.ssl;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.concurrent.FutureCallback;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpHost;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.URIScheme;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http2.ssl.ConscryptSupport;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.net.NamedEndpoint;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.ssl.SSLContexts;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Timeout;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;

public class ConscryptClientTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public ConscryptClientTlsStrategy(SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, null, initializer, verifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext, SSLSessionVerifier verifier) {
        this(sslContext, null, null, verifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext) {
        this(sslContext, null, null, null);
    }

    public ConscryptClientTlsStrategy() {
        this(SSLContexts.createSystemDefault(), null, null, null);
    }

    public ConscryptClientTlsStrategy(SSLSessionVerifier verifier) {
        this(SSLContexts.createSystemDefault(), verifier);
    }

    @Override
    public void upgrade(TransportSecurityLayer tlsSession, NamedEndpoint endpoint, Object attachment, Timeout handshakeTimeout, FutureCallback<TransportSecurityLayer> callback) {
        tlsSession.startTls(this.sslContext, endpoint, this.sslBufferMode, ConscryptSupport.initialize(attachment, this.initializer), ConscryptSupport.verify(this.verifier), handshakeTimeout, callback);
    }

    @Override
    @Deprecated
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        String scheme;
        String string = scheme = host != null ? host.getSchemeName() : null;
        if (URIScheme.HTTPS.same(scheme)) {
            this.upgrade(tlsSession, host, attachment, handshakeTimeout, null);
            return true;
        }
        return false;
    }
}

