/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.core5.http.nio.entity;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.ContentType;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.config.CharCodingConfig;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityConsumer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.CharArrayBuffer;
import java.io.IOException;
import java.nio.CharBuffer;

public class StringAsyncEntityConsumer
extends AbstractCharAsyncEntityConsumer<String> {
    private final int capacityIncrement;
    private final CharArrayBuffer content;

    public StringAsyncEntityConsumer(int bufSize, int capacityIncrement, CharCodingConfig charCodingConfig) {
        super(bufSize, charCodingConfig);
        this.capacityIncrement = Args.positive(capacityIncrement, "Capacity increment");
        this.content = new CharArrayBuffer(1024);
    }

    public StringAsyncEntityConsumer(int capacityIncrement) {
        this(8192, capacityIncrement, CharCodingConfig.DEFAULT);
    }

    public StringAsyncEntityConsumer(CharCodingConfig charCodingConfig) {
        this(8192, Integer.MAX_VALUE, charCodingConfig);
    }

    public StringAsyncEntityConsumer() {
        this(Integer.MAX_VALUE);
    }

    @Override
    protected final void streamStart(ContentType contentType) throws HttpException, IOException {
    }

    @Override
    protected int capacityIncrement() {
        int available = this.content.capacity() - this.content.length();
        return Math.max(this.capacityIncrement, available);
    }

    @Override
    protected final void data(CharBuffer src, boolean endOfStream) {
        Args.notNull(src, "CharBuffer");
        int chunk = src.remaining();
        this.content.ensureCapacity(chunk);
        src.get(this.content.array(), this.content.length(), chunk);
        this.content.setLength(this.content.length() + chunk);
    }

    @Override
    public String generateContent() {
        return this.content.toString();
    }

    @Override
    public void releaseResources() {
        this.content.clear();
    }
}

