/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.core5.http.impl.io;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.io.HttpTransportMetrics;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.io.SessionOutputBuffer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.ByteArrayBuffer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.CharArrayBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class SessionOutputBufferImpl
implements SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final BasicHttpTransportMetrics metrics;
    private final ByteArrayBuffer buffer;
    private final int fragmentSizeHint;
    private final CharsetEncoder encoder;
    private ByteBuffer bbuf;

    public SessionOutputBufferImpl(BasicHttpTransportMetrics metrics, int bufferSize, int fragmentSizeHint, CharsetEncoder charEncoder) {
        Args.positive(bufferSize, "Buffer size");
        Args.notNull(metrics, "HTTP transport metrics");
        this.metrics = metrics;
        this.buffer = new ByteArrayBuffer(bufferSize);
        this.fragmentSizeHint = fragmentSizeHint >= 0 ? fragmentSizeHint : bufferSize;
        this.encoder = charEncoder;
    }

    public SessionOutputBufferImpl(int bufferSize) {
        this(new BasicHttpTransportMetrics(), bufferSize, bufferSize, null);
    }

    public SessionOutputBufferImpl(int bufferSize, CharsetEncoder encoder) {
        this(new BasicHttpTransportMetrics(), bufferSize, bufferSize, encoder);
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    private void flushBuffer(OutputStream outputStream2) throws IOException {
        int len = this.buffer.length();
        if (len > 0) {
            outputStream2.write(this.buffer.array(), 0, len);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(len);
        }
    }

    @Override
    public void flush(OutputStream outputStream2) throws IOException {
        Args.notNull(outputStream2, "Output stream");
        this.flushBuffer(outputStream2);
        outputStream2.flush();
    }

    @Override
    public void write(byte[] b, int off, int len, OutputStream outputStream2) throws IOException {
        if (b == null) {
            return;
        }
        Args.notNull(outputStream2, "Output stream");
        if (len > this.fragmentSizeHint || len > this.buffer.capacity()) {
            this.flushBuffer(outputStream2);
            outputStream2.write(b, off, len);
            this.metrics.incrementBytesTransferred(len);
        } else {
            int freecapacity = this.buffer.capacity() - this.buffer.length();
            if (len > freecapacity) {
                this.flushBuffer(outputStream2);
            }
            this.buffer.append(b, off, len);
        }
    }

    @Override
    public void write(byte[] b, OutputStream outputStream2) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length, outputStream2);
    }

    @Override
    public void write(int b, OutputStream outputStream2) throws IOException {
        Args.notNull(outputStream2, "Output stream");
        if (this.fragmentSizeHint > 0) {
            if (this.buffer.isFull()) {
                this.flushBuffer(outputStream2);
            }
            this.buffer.append(b);
        } else {
            this.flushBuffer(outputStream2);
            outputStream2.write(b);
        }
    }

    @Override
    public void writeLine(CharArrayBuffer charbuffer, OutputStream outputStream2) throws IOException {
        if (charbuffer == null) {
            return;
        }
        Args.notNull(outputStream2, "Output stream");
        if (this.encoder == null) {
            int chunk;
            int off = 0;
            for (int remaining = charbuffer.length(); remaining > 0; remaining -= chunk) {
                chunk = this.buffer.capacity() - this.buffer.length();
                if ((chunk = Math.min(chunk, remaining)) > 0) {
                    this.buffer.append(charbuffer, off, chunk);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer(outputStream2);
                }
                off += chunk;
            }
        } else {
            CharBuffer cbuf = CharBuffer.wrap(charbuffer.array(), 0, charbuffer.length());
            this.writeEncoded(cbuf, outputStream2);
        }
        this.write(CRLF, outputStream2);
    }

    private void writeEncoded(CharBuffer cbuf, OutputStream outputStream2) throws IOException {
        CoderResult result;
        if (!cbuf.hasRemaining()) {
            return;
        }
        if (this.bbuf == null) {
            this.bbuf = ByteBuffer.allocate(1024);
        }
        this.encoder.reset();
        while (cbuf.hasRemaining()) {
            result = this.encoder.encode(cbuf, this.bbuf, true);
            this.handleEncodingResult(result, outputStream2);
        }
        result = this.encoder.flush(this.bbuf);
        this.handleEncodingResult(result, outputStream2);
        this.bbuf.clear();
    }

    private void handleEncodingResult(CoderResult result, OutputStream outputStream2) throws IOException {
        if (result.isError()) {
            result.throwException();
        }
        this.bbuf.flip();
        while (this.bbuf.hasRemaining()) {
            this.write(this.bbuf.get(), outputStream2);
        }
        this.bbuf.compact();
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

