/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.core5.http.impl.io;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.FormattedHeader;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.Header;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpMessage;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.io.HttpMessageWriter;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.io.SessionOutputBuffer;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.message.BasicLineFormatter;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.message.LineFormatter;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.CharArrayBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    private final CharArrayBuffer lineBuf;
    private final LineFormatter lineFormatter;

    public AbstractMessageWriter(LineFormatter formatter) {
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    LineFormatter getLineFormatter() {
        return this.lineFormatter;
    }

    protected abstract void writeHeadLine(T var1, CharArrayBuffer var2) throws IOException;

    @Override
    public void write(T message, SessionOutputBuffer buffer, OutputStream outputStream2) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        Args.notNull(buffer, "Session output buffer");
        Args.notNull(outputStream2, "Output stream");
        this.writeHeadLine(message, this.lineBuf);
        buffer.writeLine(this.lineBuf, outputStream2);
        Iterator<Header> it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.next();
            if (header instanceof FormattedHeader) {
                CharArrayBuffer chbuffer = ((FormattedHeader)header).getBuffer();
                buffer.writeLine(chbuffer, outputStream2);
                continue;
            }
            this.lineBuf.clear();
            this.lineFormatter.formatHeader(this.lineBuf, header);
            buffer.writeLine(this.lineBuf, outputStream2);
        }
        this.lineBuf.clear();
        buffer.writeLine(this.lineBuf, outputStream2);
    }
}

