/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.client5.http.protocol;

import com.salesforce.datacloud.shaded.org.apache.hc.core5.annotation.Contract;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.EntityDetails;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.Header;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpRequest;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.Method;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.ProtocolException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestValidateTrace
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestValidateTrace();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        if (Method.TRACE.isSame(request.getMethod())) {
            if (entity != null) {
                throw new ProtocolException("TRACE request MUST NOT contain a request body.");
            }
            Header authHeader = request.getHeader("Authorization");
            if (authHeader != null) {
                throw new ProtocolException("TRACE request MUST NOT contain an Authorization header.");
            }
            Header cookieHeader = request.getHeader("Cookie");
            if (cookieHeader != null) {
                throw new ProtocolException("TRACE request MUST NOT contain a Cookie header.");
            }
        }
    }
}

