/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.classic;

import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.AuthenticationStrategy;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.HttpRoute;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.RouteInfo;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.AuthExchange;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.AuthScope;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.ChallengeType;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.Credentials;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.config.RequestConfig;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.HttpAuthenticator;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.protocol.RequestClientConnControl;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpEntity;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpHost;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.Method;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.config.CharCodingConfig;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.config.Http1Config;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.config.Lookup;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.config.RegistryBuilder;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.io.HttpConnectionFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.message.StatusLine;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.protocol.RequestTargetHost;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.protocol.RequestUserAgent;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.net.Socket;

public class ProxyClient {
    private final HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthExchange proxyAuthExchange;
    private final Lookup<AuthSchemeFactory> authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<ManagedHttpClientConnection> connFactory, Http1Config h1Config, CharCodingConfig charCodingConfig, RequestConfig requestConfig) {
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.builder().http1Config(h1Config).charCodingConfig(charCodingConfig).build();
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new DefaultHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new DefaultAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthExchange = new AuthExchange();
        this.authSchemeRegistry = RegistryBuilder.create().register("Basic", BasicSchemeFactory.INSTANCE).register("Digest", (BasicSchemeFactory)((Object)DigestSchemeFactory.INSTANCE)).build();
        this.reuseStrategy = DefaultClientConnectionReuseStrategy.INSTANCE;
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null, null);
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        int status;
        ClassicHttpResponse response;
        Args.notNull(proxy, "Proxy host");
        Args.notNull(target, "Target host");
        Args.notNull(credentials, "Credentials");
        Args.check(target.getPort() > 0, "A valid port number must be provided for the tunnel CONNECT request.");
        HttpRoute route = new HttpRoute(target, null, proxy, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection conn = this.connFactory.createConnection(null);
        HttpClientContext context = HttpClientContext.create();
        BasicClassicHttpRequest connect2 = new BasicClassicHttpRequest(Method.CONNECT, proxy, target.toHostString());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxy), credentials);
        context.setRequest(connect2);
        context.setRoute(route);
        context.setCredentialsProvider(credsProvider);
        context.setAuthSchemeRegistry(this.authSchemeRegistry);
        context.setRequestConfig(this.requestConfig);
        this.requestExec.preProcess(connect2, this.httpProcessor, context);
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket);
            }
            this.authenticator.addAuthResponse(proxy, ChallengeType.PROXY, connect2, this.proxyAuthExchange, context);
            response = this.requestExec.execute(connect2, conn, context);
            status = response.getCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response);
            }
            if (!this.authenticator.isChallenged(proxy, ChallengeType.PROXY, response, this.proxyAuthExchange, context) || !this.authenticator.updateAuthState(proxy, ChallengeType.PROXY, response, this.proxyAuthStrategy, this.proxyAuthExchange, context)) break;
            if (this.reuseStrategy.keepAlive(connect2, response, context)) {
                HttpEntity entity = response.getEntity();
                EntityUtils.consume(entity);
            } else {
                conn.close();
            }
            connect2.removeHeaders("Proxy-Authorization");
        }
        status = response.getCode();
        if (status > 299) {
            EntityUtils.consume(response.getEntity());
            conn.close();
            throw new HttpException("Tunnel refused: " + new StatusLine(response));
        }
        return conn.getSocket();
    }
}

