/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.calcite.avatica.util;

import java.io.IOException;
import java.io.OutputStream;

public class UnsynchronizedBuffer
extends OutputStream {
    private static final int LARGE_BUFFER_SIZE = 65536;
    final int initialCapacity;
    int offset = 0;
    byte[] data;

    public UnsynchronizedBuffer() {
        this(4096);
    }

    public UnsynchronizedBuffer(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.data = new byte[initialCapacity];
    }

    private void reserve(int l) {
        if (this.offset + l > this.data.length) {
            int newSize = UnsynchronizedBuffer.nextArraySize(this.offset + l);
            byte[] newData = new byte[newSize];
            System.arraycopy(this.data, 0, newData, 0, this.offset);
            this.data = newData;
        }
    }

    @Override
    public void write(byte[] bytes, int off, int length) {
        this.reserve(length);
        System.arraycopy(bytes, off, this.data, this.offset, length);
        this.offset += length;
    }

    @Override
    public void write(int b) throws IOException {
        this.reserve(1);
        this.data[this.offset] = (byte)b;
        ++this.offset;
    }

    public byte[] toArray() {
        byte[] ret = new byte[this.offset];
        System.arraycopy(this.data, 0, ret, 0, this.offset);
        return ret;
    }

    public void reset() {
        this.offset = 0;
        if (this.data.length >= 65536) {
            this.data = new byte[this.initialCapacity];
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.data.length;
    }

    public static int nextArraySize(int i) {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        if (i > 0x40000000) {
            return Integer.MAX_VALUE;
        }
        if (i == 0) {
            return 1;
        }
        int ret = i;
        --ret;
        ret |= ret >> 1;
        ret |= ret >> 2;
        ret |= ret >> 4;
        ret |= ret >> 8;
        ret |= ret >> 16;
        return ++ret;
    }
}

