/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote;

import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.ConnectionConfig;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote.AuthenticationType;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote.GSSAuthenticateable;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote.HttpClientPoolConfigurable;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.ClientProtocolException;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.SystemDefaultDnsResolver;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.AuthScope;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.Credentials;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.CredentialsProvider;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.KerberosConfig;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.KerberosCredentials;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.config.RequestConfig;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.auth.SPNegoSchemeFactory;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.salesforce.datacloud.shaded.org.apache.hc.client5.http.routing.RoutingSupport;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.ContentType;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.HttpHost;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.NoHttpResponseException;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.config.Lookup;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.config.RegistryBuilder;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import com.salesforce.datacloud.shaded.org.apache.hc.core5.http.io.entity.EntityUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaCommonsHttpClientImpl
implements AvaticaHttpClient,
HttpClientPoolConfigurable,
UsernamePasswordAuthenticateable,
GSSAuthenticateable {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientImpl.class);
    private static final boolean USE_CANONICAL_HOSTNAME = Boolean.parseBoolean(System.getProperty("avatica.http.spnego.use_canonical_hostname", "true"));
    private static final boolean STRIP_PORT_ON_SERVER_LOOKUP = true;
    private static final KerberosConfig KERBEROS_CONFIG = KerberosConfig.custom().setStripPort(true).setUseCanonicalHostname(USE_CANONICAL_HOSTNAME).build();
    private static AuthScope anyAuthScope = new AuthScope(null, -1);
    protected final URI uri;
    protected HttpHost httpHost;
    protected BasicAuthCache authCache;
    protected CloseableHttpClient client;
    protected PoolingHttpClientConnectionManager pool;
    protected UsernamePasswordCredentials credentials = null;
    protected CredentialsProvider credentialsProvider = null;
    protected Lookup<AuthSchemeFactory> authRegistry = null;
    protected Object userToken;
    protected HttpClientContext context;
    protected long connectTimeout;
    protected long responseTimeout;

    @Deprecated
    public AvaticaCommonsHttpClientImpl(URL url) {
        this.uri = AvaticaCommonsHttpClientImpl.toURI(Objects.requireNonNull(url));
    }

    public AvaticaCommonsHttpClientImpl(URI uri) {
        this.uri = uri;
    }

    protected void initializeClient(PoolingHttpClientConnectionManager pool, ConnectionConfig config) {
        this.authCache = new BasicAuthCache();
        this.connectTimeout = config.getHttpConnectionTimeout();
        this.responseTimeout = config.getHttpResponseTimeout();
        RequestConfig requestConfig = this.createRequestConfig();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(pool).setDefaultRequestConfig(requestConfig);
        this.client = httpClientBuilder.build();
        this.context = HttpClientContext.create();
        if (null != this.credentialsProvider) {
            this.context.setCredentialsProvider(this.credentialsProvider);
            this.context.setAuthSchemeRegistry(this.authRegistry);
            this.context.setAuthCache(this.authCache);
        }
        if (null != this.userToken) {
            this.context.setUserToken(this.userToken);
        }
    }

    private RequestConfig createRequestConfig() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout(this.responseTimeout, TimeUnit.MILLISECONDS);
        ArrayList<String> preferredSchemes = new ArrayList<String>();
        if (this.authRegistry != null) {
            if (this.authRegistry.lookup("Digest") != null) {
                preferredSchemes.add("Digest");
            }
            if (this.authRegistry.lookup("Basic") != null) {
                preferredSchemes.add("Basic");
            }
            if (this.authRegistry.lookup("Negotiate") != null) {
                preferredSchemes.add("Negotiate");
            }
            requestConfigBuilder.setTargetPreferredAuthSchemes(preferredSchemes);
            requestConfigBuilder.setProxyPreferredAuthSchemes(preferredSchemes);
        }
        return requestConfigBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        while (true) {
            ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
            HttpPost post = new HttpPost(this.uri);
            post.setEntity(entity);
            if (this.httpHost == null) {
                try {
                    this.httpHost = RoutingSupport.determineHost(post);
                }
                catch (HttpException e) {
                    LOG.debug("Failed to execute HTTP request", e);
                    throw new RuntimeException("Could not determine Http Host from URI", e);
                }
            }
            try {
                ClassicHttpResponse response = this.executeOpen(this.httpHost, post, this.context);
                Throwable throwable = null;
                try {
                    int statusCode = response.getCode();
                    if (200 == statusCode || 500 == statusCode) {
                        this.userToken = this.context.getUserToken();
                        byte[] byArray = EntityUtils.toByteArray(response.getEntity());
                        return byArray;
                    }
                    if (503 == statusCode) {
                        LOG.debug("Failed to connect to server (HTTP/503), retrying");
                        continue;
                    }
                    throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                    continue;
                }
            }
            catch (NoHttpResponseException e) {
                LOG.debug("The server failed to issue an HTTP response, retrying");
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.debug("Failed to execute HTTP request", e);
                throw new RuntimeException(e);
            }
            break;
        }
    }

    ClassicHttpResponse executeOpen(HttpHost httpHost, HttpPost post, HttpClientContext context) throws IOException, ClientProtocolException {
        return this.client.executeOpen(httpHost, post, context);
    }

    @Override
    public void setUsernamePassword(AuthenticationType authType, String username, String password) {
        this.credentials = new UsernamePasswordCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password).toCharArray());
        this.credentialsProvider = new BasicCredentialsProvider();
        ((BasicCredentialsProvider)this.credentialsProvider).setCredentials(anyAuthScope, this.credentials);
        RegistryBuilder<AuthSchemeFactory> authRegistryBuilder = RegistryBuilder.create();
        switch (authType) {
            case BASIC: {
                authRegistryBuilder.register("Basic", new BasicSchemeFactory());
                break;
            }
            case DIGEST: {
                authRegistryBuilder.register("Digest", new DigestSchemeFactory());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentiation type: " + (Object)((Object)authType));
            }
        }
        this.authRegistry = authRegistryBuilder.build();
        this.context.setCredentialsProvider(this.credentialsProvider);
        this.context.setAuthSchemeRegistry(this.authRegistry);
        this.context.setRequestConfig(this.createRequestConfig());
    }

    @Override
    public void setGSSCredential(GSSCredential credential) {
        this.authRegistry = RegistryBuilder.create().register("Negotiate", new SPNegoSchemeFactory(KERBEROS_CONFIG, SystemDefaultDnsResolver.INSTANCE)).build();
        this.credentialsProvider = new BasicCredentialsProvider();
        if (null != credential) {
            ((BasicCredentialsProvider)this.credentialsProvider).setCredentials(anyAuthScope, new KerberosCredentials(credential));
        } else {
            ((BasicCredentialsProvider)this.credentialsProvider).setCredentials(anyAuthScope, EmptyCredentials.INSTANCE);
        }
        this.context.setCredentialsProvider(this.credentialsProvider);
        this.context.setAuthSchemeRegistry(this.authRegistry);
        this.context.setRequestConfig(this.createRequestConfig());
    }

    private static URI toURI(URL url) throws RuntimeException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setHttpClientPool(PoolingHttpClientConnectionManager pool, ConnectionConfig config) {
        this.initializeClient(pool, config);
    }

    private static class EmptyCredentials
    implements Credentials {
        public static final EmptyCredentials INSTANCE = new EmptyCredentials();

        private EmptyCredentials() {
        }

        @Override
        @Deprecated
        public char[] getPassword() {
            return null;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }
    }
}

