/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.org.apache.arrow.memory.util.hash;

import com.salesforce.datacloud.shaded.org.apache.arrow.memory.ArrowBuf;
import com.salesforce.datacloud.shaded.org.apache.arrow.memory.util.MemoryUtil;
import com.salesforce.datacloud.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MurmurHasher
implements ArrowBufHasher {
    private final int seed;

    public MurmurHasher() {
        this(0);
    }

    public MurmurHasher(int seed) {
        this.seed = seed;
    }

    @Override
    public int hashCode(long address, long length) {
        return MurmurHasher.hashCode(address, length, this.seed);
    }

    @Override
    public int hashCode(ArrowBuf buf, long offset, long length) {
        buf.checkBytes(offset, offset + length);
        return this.hashCode(buf.memoryAddress() + offset, length);
    }

    public static int hashCode(ArrowBuf buf, long offset, long length, int seed) {
        buf.checkBytes(offset, offset + length);
        return MurmurHasher.hashCode(buf.memoryAddress() + offset, length, seed);
    }

    public static int hashCode(long address, long length, int seed) {
        int intValue;
        int index = 0;
        int hash = seed;
        while ((long)(index + 4) <= length) {
            intValue = MemoryUtil.UNSAFE.getInt(address + (long)index);
            hash = MurmurHasher.combineHashCode(hash, intValue);
            index += 4;
        }
        if ((long)index < length) {
            intValue = 0;
            for (long i = length - 1L; i >= (long)index; --i) {
                intValue <<= 8;
                intValue |= MemoryUtil.UNSAFE.getByte(address + i) & 0xFF;
                ++index;
            }
            hash = MurmurHasher.combineHashCode(hash, intValue);
        }
        return MurmurHasher.finalizeHashCode(hash, length);
    }

    public static int combineHashCode(int currentHashCode, int intValue) {
        int c1 = -862048943;
        int c2 = 461845907;
        int r1 = 15;
        int r2 = 13;
        int m4 = 5;
        int n = -430675100;
        int k = intValue;
        k *= c1;
        k = MurmurHasher.rotateLeft(k, r1);
        int hash = currentHashCode;
        hash ^= (k *= c2);
        hash = MurmurHasher.rotateLeft(hash, r2);
        hash = hash * m4 + n;
        return hash;
    }

    public static int finalizeHashCode(int hashCode, long length) {
        hashCode ^= (int)length;
        hashCode ^= hashCode >>> 16;
        hashCode *= -2048144789;
        hashCode ^= hashCode >>> 13;
        hashCode *= -1028477387;
        hashCode ^= hashCode >>> 16;
        return hashCode;
    }

    private static int rotateLeft(int value, int count) {
        return value << count | value >>> 32 - count;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MurmurHasher)) {
            return false;
        }
        MurmurHasher that = (MurmurHasher)o;
        return this.seed == that.seed;
    }

    public int hashCode() {
        return this.seed;
    }
}

