/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.lang;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Arrays;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class Collections {
    private Collections() {
    }

    public static <T> List<T> emptyList() {
        return java.util.Collections.emptyList();
    }

    public static <T> Set<T> emptySet() {
        return java.util.Collections.emptySet();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return java.util.Collections.emptyMap();
    }

    @SafeVarargs
    public static <T> List<T> of(T ... elements) {
        if (elements == null || elements.length == 0) {
            return java.util.Collections.emptyList();
        }
        return java.util.Collections.unmodifiableList(java.util.Arrays.asList(elements));
    }

    public static <T> Set<T> asSet(Collection<T> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        if (Collections.isEmpty(c)) {
            return java.util.Collections.emptySet();
        }
        return java.util.Collections.unmodifiableSet(new LinkedHashSet<T>(c));
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... elements) {
        if (elements == null || elements.length == 0) {
            return java.util.Collections.emptySet();
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(java.util.Arrays.asList(elements));
        return Collections.immutable(set);
    }

    public static <K, V> Map<K, V> immutable(Map<K, V> m4) {
        return m4 != null ? java.util.Collections.unmodifiableMap(m4) : null;
    }

    public static <T> Set<T> immutable(Set<T> set) {
        return set != null ? java.util.Collections.unmodifiableSet(set) : null;
    }

    public static <T> List<T> immutable(List<T> list) {
        return list != null ? java.util.Collections.unmodifiableList(list) : null;
    }

    public static <T, C extends Collection<T>> C immutable(C c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Set) {
            return (C)java.util.Collections.unmodifiableSet((Set)c);
        }
        if (c instanceof List) {
            return (C)java.util.Collections.unmodifiableList((List)c);
        }
        return (C)java.util.Collections.unmodifiableCollection(c);
    }

    public static <T> Set<T> nullSafe(Set<T> s2) {
        return s2 == null ? Collections.emptySet() : s2;
    }

    public static <T> Collection<T> nullSafe(Collection<T> c) {
        return c == null ? Collections.emptyList() : c;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return Collections.size(collection) == 0;
    }

    public static int size(Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static int size(Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return Collections.size(map) == 0;
    }

    public static List arrayToList(Object source2) {
        return java.util.Arrays.asList(Objects.toObjectArray(source2));
    }

    @SafeVarargs
    public static <T> Set<T> concat(Set<T> c, T ... elements) {
        int size = Math.max(1, Collections.size(c) + Arrays.length(elements));
        LinkedHashSet<T> set = new LinkedHashSet<T>(size);
        set.addAll(c);
        java.util.Collections.addAll(set, elements);
        return Collections.immutable(set);
    }

    public static void mergeArrayIntoCollection(Object array, Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        Object[] arr = Objects.toObjectArray(array);
        java.util.Collections.addAll(collection, arr);
    }

    public static void mergePropertiesIntoMap(Properties props, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = props.getProperty(key);
                if (value == null) {
                    value = props.get(key);
                }
                map.put(key, value);
            }
        }
    }

    public static boolean contains(Iterator iterator2, Object element) {
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                Object candidate = iterator2.next();
                if (!Objects.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!Objects.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection source2, Collection candidates) {
        if (Collections.isEmpty(source2) || Collections.isEmpty(candidates)) {
            return false;
        }
        for (Object candidate : candidates) {
            if (!source2.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstMatch(Collection source2, Collection candidates) {
        if (Collections.isEmpty(source2) || Collections.isEmpty(candidates)) {
            return null;
        }
        for (Object candidate : candidates) {
            if (!source2.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static <T> T findValueOfType(Collection<?> collection, Class<T> type) {
        if (Collections.isEmpty(collection)) {
            return null;
        }
        T value = null;
        for (Object element : collection) {
            if (type != null && !type.isInstance(element)) continue;
            if (value != null) {
                return null;
            }
            value = (T)element;
        }
        return value;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?>[] types) {
        if (Collections.isEmpty(collection) || Objects.isEmpty(types)) {
            return null;
        }
        for (Class<?> type : types) {
            Object value = Collections.findValueOfType(collection, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection collection) {
        if (Collections.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static Class<?> findCommonElementType(Collection collection) {
        if (Collections.isEmpty(collection)) {
            return null;
        }
        Class<?> candidate = null;
        for (Object val : collection) {
            if (val == null) continue;
            if (candidate == null) {
                candidate = val.getClass();
                continue;
            }
            if (candidate == val.getClass()) continue;
            return null;
        }
        return candidate;
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] array) {
        ArrayList<E> elements = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            elements.add(enumeration.nextElement());
        }
        return elements.toArray(array);
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<E> enumeration;

        public EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

