/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.IdRegistry;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultMacAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.EcSignatureAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.EdSignatureAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.NoneSignatureAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.RsaSignatureAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Password;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.SecretKey;

public final class StandardSecureDigestAlgorithms
extends IdRegistry<SecureDigestAlgorithm<?, ?>> {
    public static final String NAME = "JWS Digital Signature or MAC";

    public StandardSecureDigestAlgorithms() {
        super(NAME, Collections.of(NoneSignatureAlgorithm.INSTANCE, DefaultMacAlgorithm.HS256, DefaultMacAlgorithm.HS384, DefaultMacAlgorithm.HS512, RsaSignatureAlgorithm.RS256, RsaSignatureAlgorithm.RS384, RsaSignatureAlgorithm.RS512, RsaSignatureAlgorithm.PS256, RsaSignatureAlgorithm.PS384, RsaSignatureAlgorithm.PS512, EcSignatureAlgorithm.ES256, EcSignatureAlgorithm.ES384, EcSignatureAlgorithm.ES512, EdSignatureAlgorithm.INSTANCE));
    }

    public static <K extends Key> SecureDigestAlgorithm<K, ?> findBySigningKey(K key) {
        SecureDigestAlgorithm<SecretKey, SecretKey> alg = null;
        if (key instanceof SecretKey && !(key instanceof Password)) {
            alg = DefaultMacAlgorithm.findByKey(key);
        } else if (key instanceof PrivateKey) {
            PrivateKey pk = (PrivateKey)key;
            alg = RsaSignatureAlgorithm.findByKey(pk);
            if (alg == null) {
                alg = EcSignatureAlgorithm.findByKey(pk);
            }
            if (alg == null && EdSignatureAlgorithm.isSigningKey(pk)) {
                alg = EdSignatureAlgorithm.INSTANCE;
            }
        }
        return alg;
    }
}

