/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeySupplier;
import java.security.Key;
import java.security.Provider;

public class ProviderKey<T extends Key>
implements Key,
KeySupplier<T> {
    private final T key;
    private final Provider provider;

    public static Provider getProvider(Key key, Provider backup) {
        if (key instanceof ProviderKey) {
            ProviderKey pkey = (ProviderKey)key;
            return Assert.stateNotNull(pkey.getProvider(), "ProviderKey provider can never be null.");
        }
        return backup;
    }

    public static <K extends Key> K getKey(K key) {
        return (K)(key instanceof ProviderKey ? ((ProviderKey)key).getKey() : key);
    }

    ProviderKey(Provider provider, T key) {
        this.provider = Assert.notNull(provider, "Provider cannot be null.");
        this.key = (Key)Assert.notNull(key, "Key argument cannot be null.");
        if (key instanceof ProviderKey) {
            String msg = "Nesting not permitted.";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public T getKey() {
        return this.key;
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.key.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.key.getEncoded();
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

