/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Converter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultJwkSet;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkBuilderSupplier;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkConverter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Supplier;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.DynamicJwkBuilder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Jwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.JwkSet;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.MalformedKeySetException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.UnsupportedKeyException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JwkSetConverter
implements Converter<JwkSet, Object> {
    private final Converter<Jwk<?>, Object> JWK_CONVERTER;
    private final Parameter<Set<Jwk<?>>> PARAM;
    private final boolean ignoreUnsupported;

    public JwkSetConverter() {
        this(JwkBuilderSupplier.DEFAULT, true);
    }

    public JwkSetConverter(boolean ignoreUnsupported) {
        this(JwkBuilderSupplier.DEFAULT, ignoreUnsupported);
    }

    public JwkSetConverter(Supplier<DynamicJwkBuilder<?, ?>> supplier, boolean ignoreUnsupported) {
        this(new JwkConverter(supplier), ignoreUnsupported);
    }

    public JwkSetConverter(Converter<Jwk<?>, Object> jwkConverter, boolean ignoreUnsupported) {
        this.JWK_CONVERTER = Assert.notNull(jwkConverter, "JWK converter cannot be null.");
        this.PARAM = DefaultJwkSet.param(jwkConverter);
        this.ignoreUnsupported = ignoreUnsupported;
    }

    public boolean isIgnoreUnsupported() {
        return this.ignoreUnsupported;
    }

    @Override
    public Object applyTo(JwkSet jwkSet) {
        return jwkSet;
    }

    @Override
    public JwkSet applyFrom(Object o) {
        Assert.notNull(o, "Value cannot be null.");
        if (o instanceof JwkSet) {
            return (JwkSet)o;
        }
        if (!(o instanceof Map)) {
            String msg = "Value must be a Map<String,?> (JSON Object). Type found: " + o.getClass().getName() + ".";
            throw new IllegalArgumentException(msg);
        }
        Map m4 = Collections.immutable((Map)o);
        if (Collections.isEmpty(m4) || !m4.containsKey(this.PARAM.getId())) {
            String msg = "Missing required " + this.PARAM + " parameter.";
            throw new MalformedKeySetException(msg);
        }
        Object val = m4.get(this.PARAM.getId());
        if (val == null) {
            String msg = "JWK Set " + this.PARAM + " value cannot be null.";
            throw new MalformedKeySetException(msg);
        }
        if (val instanceof Supplier) {
            val = ((Supplier)val).get();
        }
        if (!(val instanceof Collection)) {
            String msg = "JWK Set " + this.PARAM + " value must be a Collection (JSON Array). Type found: " + val.getClass().getName();
            throw new MalformedKeySetException(msg);
        }
        int size = Collections.size((Collection)val);
        if (size == 0) {
            String msg = "JWK Set " + this.PARAM + " collection cannot be empty.";
            throw new MalformedKeySetException(msg);
        }
        LinkedHashMap src = new LinkedHashMap(Collections.size((Map)o));
        for (Map.Entry entry : ((Map)o).entrySet()) {
            Object key = Assert.notNull(entry.getKey(), "JWK Set map key cannot be null.");
            if (!(key instanceof String)) {
                String msg = "JWK Set map keys must be Strings. Encountered key '" + key + "' of type " + key.getClass().getName();
                throw new IllegalArgumentException(msg);
            }
            String skey = (String)key;
            src.put(skey, entry.getValue());
        }
        LinkedHashSet jwks = new LinkedHashSet(size);
        int i = 0;
        for (Object candidate : (Collection)val) {
            block14: {
                try {
                    Jwk<?> jwk = this.JWK_CONVERTER.applyFrom(candidate);
                    jwks.add(jwk);
                }
                catch (UnsupportedKeyException e) {
                    if (!this.ignoreUnsupported) {
                        String msg = "JWK Set keys[" + i + "]: " + e.getMessage();
                        throw new UnsupportedKeyException(msg, e);
                    }
                }
                catch (KeyException | IllegalArgumentException e) {
                    if (this.ignoreUnsupported) break block14;
                    String msg = "JWK Set keys[" + i + "]: " + e.getMessage();
                    throw new MalformedKeySetException(msg, e);
                }
            }
            ++i;
        }
        src.remove(this.PARAM.getId());
        src.put(this.PARAM.getId(), jwks);
        return new DefaultJwkSet(this.PARAM, src);
    }
}

