/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultKeyResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.DecryptionKeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecurityException;
import javax.crypto.SecretKey;

public class DirectKeyAlgorithm
implements KeyAlgorithm<SecretKey, SecretKey> {
    static final String ID = "dir";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        SecretKey key = (SecretKey)Assert.notNull(request.getPayload(), "Encryption key cannot be null.");
        return new DefaultKeyResult(key);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        return (SecretKey)Assert.notNull(request.getKey(), "Decryption key cannot be null.");
    }
}

