/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.ParameterReadable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameters;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractPublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.FieldElementConverter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.JwkContext;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.EcPublicJwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.PublicJwk;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.util.List;
import java.util.Set;

class DefaultEcPublicJwk
extends AbstractPublicJwk<ECPublicKey>
implements EcPublicJwk {
    static final String TYPE_VALUE = "EC";
    static final Parameter<String> CRV = Parameters.string("crv", "Curve");
    static final Parameter<BigInteger> X = (Parameter)Parameters.bigInt("x", "X Coordinate").setConverter(FieldElementConverter.B64URL_CONVERTER).build();
    static final Parameter<BigInteger> Y = (Parameter)Parameters.bigInt("y", "Y Coordinate").setConverter(FieldElementConverter.B64URL_CONVERTER).build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(AbstractAsymmetricJwk.PARAMS, CRV, X, Y);
    static final List<Parameter<?>> THUMBPRINT_PARAMS = Collections.of(CRV, KTY, X, Y);

    DefaultEcPublicJwk(JwkContext<ECPublicKey> ctx) {
        super(ctx, THUMBPRINT_PARAMS);
    }

    static boolean equalsPublic(ParameterReadable self, Object candidate) {
        return Parameters.equals(self, candidate, CRV) && Parameters.equals(self, candidate, X) && Parameters.equals(self, candidate, Y);
    }

    @Override
    protected boolean equals(PublicJwk<?> jwk) {
        return jwk instanceof EcPublicJwk && DefaultEcPublicJwk.equalsPublic(this, jwk);
    }
}

