/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.CheckedFunction;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AesAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultKeyResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.DecryptionKeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecretKeyAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class AesWrapKeyAlgorithm
extends AesAlgorithm
implements SecretKeyAlgorithm {
    private static final String TRANSFORMATION = "AESWrap";

    public AesWrapKeyAlgorithm(int keyLen) {
        super("A" + keyLen + "KW", TRANSFORMATION, keyLen);
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        final SecretKey kek = this.assertKey((SecretKey)request.getPayload());
        final SecretKey cek = this.generateCek(request);
        byte[] ciphertext = this.jca(request).withCipher(new CheckedFunction<Cipher, byte[]>(){

            @Override
            public byte[] apply(Cipher cipher) throws Exception {
                cipher.init(3, kek);
                return cipher.wrap(cek);
            }
        });
        return new DefaultKeyResult(cek, ciphertext);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        final SecretKey kek = this.assertKey((SecretKey)request.getKey());
        final byte[] cekBytes = Assert.notEmpty((byte[])request.getPayload(), "Request content (encrypted key) cannot be null or empty.");
        return this.jca(request).withCipher(new CheckedFunction<Cipher, SecretKey>(){

            @Override
            public SecretKey apply(Cipher cipher) throws Exception {
                cipher.init(4, kek);
                Key key = cipher.unwrap(cekBytes, "AES", 3);
                Assert.state(key instanceof SecretKey, "Cipher unwrap must return a SecretKey instance.");
                return (SecretKey)key;
            }
        });
    }
}

