/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Bytes;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Converters;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.ECCurve;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Encoders;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Jwk;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.UnsupportedKeyException;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.spec.EllipticCurve;
import java.util.Set;

abstract class AbstractEcJwkFactory<K extends Key & ECKey, J extends Jwk<K>>
extends AbstractFamilyJwkFactory<K, J> {
    protected static ECCurve getCurveByJwaId(String jwaCurveId) {
        ECCurve curve = ECCurve.findById(jwaCurveId);
        if (curve == null) {
            String msg = "Unrecognized JWA EC curve id '" + jwaCurveId + "'";
            throw new UnsupportedKeyException(msg);
        }
        return curve;
    }

    static String toOctetString(EllipticCurve curve, BigInteger coordinate) {
        byte[] bytes = Converters.BIGINT_UBYTES.applyTo(coordinate);
        int fieldSizeInBits = curve.getField().getFieldSize();
        int mlen = Bytes.length(fieldSizeInBits);
        bytes = Bytes.prepad(bytes, mlen);
        return Encoders.BASE64URL.encode(bytes);
    }

    AbstractEcJwkFactory(Class<K> keyType, Set<Parameter<?>> params) {
        super("EC", keyType, params);
    }
}

