/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Converter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import java.net.URI;

public class UriStringConverter
implements Converter<URI, CharSequence> {
    @Override
    public String applyTo(URI uri) {
        Assert.notNull(uri, "URI cannot be null.");
        return uri.toString();
    }

    @Override
    public URI applyFrom(CharSequence s2) {
        Assert.hasText(s2, "URI string cannot be null or empty.");
        try {
            return URI.create(s2.toString());
        }
        catch (Exception e) {
            String msg = "Unable to convert String value '" + s2 + "' to URI instance: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

