/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.Identifiable;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Function;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.StringRegistry;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Strings;
import java.util.Collection;

public class IdRegistry<T extends Identifiable>
extends StringRegistry<T> {
    public static final Function<Identifiable, String> FN = new Function<Identifiable, String>(){

        @Override
        public String apply(Identifiable identifiable) {
            Assert.notNull(identifiable, "Identifiable argument cannot be null.");
            return Assert.notNull(Strings.clean(identifiable.getId()), "Identifier cannot be null or empty.");
        }
    };

    public static <T extends Identifiable> Function<T, String> fn() {
        return FN;
    }

    public IdRegistry(String name, Collection<T> instances) {
        this(name, instances, true);
    }

    public IdRegistry(String name, Collection<T> instances, boolean caseSensitive) {
        super(name, "id", Assert.notEmpty(instances, "Collection of Identifiable instances may not be null or empty."), IdRegistry.fn(), caseSensitive);
    }
}

